package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsCloudWatchAlarmDimensionsDetails(
    name: Optional[NonEmptyString] = Optional.Absent,
    value: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsCloudWatchAlarmDimensionsDetails = {
    import AwsCloudWatchAlarmDimensionsDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsCloudWatchAlarmDimensionsDetails
      .builder()
      .optionallyWith(
        name.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        value.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.value)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsCloudWatchAlarmDimensionsDetails.ReadOnly =
    zio.aws.securityhub.model.AwsCloudWatchAlarmDimensionsDetails
      .wrap(buildAwsValue())
}
object AwsCloudWatchAlarmDimensionsDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsCloudWatchAlarmDimensionsDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsCloudWatchAlarmDimensionsDetails =
      zio.aws.securityhub.model.AwsCloudWatchAlarmDimensionsDetails(
        name.map(value => value),
        value.map(value => value)
      )
    def name: Optional[NonEmptyString]
    def value: Optional[NonEmptyString]
    def getName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("name", name)
    def getValue: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsCloudWatchAlarmDimensionsDetails
  ) extends zio.aws.securityhub.model.AwsCloudWatchAlarmDimensionsDetails.ReadOnly {
    override val name: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val value: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.value())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsCloudWatchAlarmDimensionsDetails
  ): zio.aws.securityhub.model.AwsCloudWatchAlarmDimensionsDetails.ReadOnly =
    new Wrapper(impl)
}
