package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsCloudFormationStackOutputsDetails(
    description: Optional[NonEmptyString] = Optional.Absent,
    outputKey: Optional[NonEmptyString] = Optional.Absent,
    outputValue: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsCloudFormationStackOutputsDetails = {
    import AwsCloudFormationStackOutputsDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsCloudFormationStackOutputsDetails
      .builder()
      .optionallyWith(
        description.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        outputKey.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.outputKey)
      .optionallyWith(
        outputValue.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.outputValue)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsCloudFormationStackOutputsDetails.ReadOnly =
    zio.aws.securityhub.model.AwsCloudFormationStackOutputsDetails
      .wrap(buildAwsValue())
}
object AwsCloudFormationStackOutputsDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsCloudFormationStackOutputsDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsCloudFormationStackOutputsDetails =
      zio.aws.securityhub.model.AwsCloudFormationStackOutputsDetails(
        description.map(value => value),
        outputKey.map(value => value),
        outputValue.map(value => value)
      )
    def description: Optional[NonEmptyString]
    def outputKey: Optional[NonEmptyString]
    def outputValue: Optional[NonEmptyString]
    def getDescription: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("description", description)
    def getOutputKey: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("outputKey", outputKey)
    def getOutputValue: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("outputValue", outputValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsCloudFormationStackOutputsDetails
  ) extends zio.aws.securityhub.model.AwsCloudFormationStackOutputsDetails.ReadOnly {
    override val description: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val outputKey: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.outputKey())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val outputValue: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.outputValue())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsCloudFormationStackOutputsDetails
  ): zio.aws.securityhub.model.AwsCloudFormationStackOutputsDetails.ReadOnly =
    new Wrapper(impl)
}
