package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsBackupBackupPlanRuleDetails(
    targetBackupVault: Optional[NonEmptyString] = Optional.Absent,
    startWindowMinutes: Optional[Long] = Optional.Absent,
    scheduleExpression: Optional[NonEmptyString] = Optional.Absent,
    ruleName: Optional[NonEmptyString] = Optional.Absent,
    ruleId: Optional[NonEmptyString] = Optional.Absent,
    enableContinuousBackup: Optional[Boolean] = Optional.Absent,
    completionWindowMinutes: Optional[Long] = Optional.Absent,
    copyActions: Optional[Iterable[
      zio.aws.securityhub.model.AwsBackupBackupPlanRuleCopyActionsDetails
    ]] = Optional.Absent,
    lifecycle: Optional[
      zio.aws.securityhub.model.AwsBackupBackupPlanLifecycleDetails
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsBackupBackupPlanRuleDetails = {
    import AwsBackupBackupPlanRuleDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsBackupBackupPlanRuleDetails
      .builder()
      .optionallyWith(
        targetBackupVault.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.targetBackupVault)
      .optionallyWith(startWindowMinutes.map(value => value: java.lang.Long))(
        _.startWindowMinutes
      )
      .optionallyWith(
        scheduleExpression.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.scheduleExpression)
      .optionallyWith(
        ruleName.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.ruleName)
      .optionallyWith(
        ruleId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.ruleId)
      .optionallyWith(
        enableContinuousBackup.map(value => value: java.lang.Boolean)
      )(_.enableContinuousBackup)
      .optionallyWith(
        completionWindowMinutes.map(value => value: java.lang.Long)
      )(_.completionWindowMinutes)
      .optionallyWith(
        copyActions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.copyActions)
      .optionallyWith(lifecycle.map(value => value.buildAwsValue()))(
        _.lifecycle
      )
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsBackupBackupPlanRuleDetails.ReadOnly =
    zio.aws.securityhub.model.AwsBackupBackupPlanRuleDetails
      .wrap(buildAwsValue())
}
object AwsBackupBackupPlanRuleDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsBackupBackupPlanRuleDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsBackupBackupPlanRuleDetails =
      zio.aws.securityhub.model.AwsBackupBackupPlanRuleDetails(
        targetBackupVault.map(value => value),
        startWindowMinutes.map(value => value),
        scheduleExpression.map(value => value),
        ruleName.map(value => value),
        ruleId.map(value => value),
        enableContinuousBackup.map(value => value),
        completionWindowMinutes.map(value => value),
        copyActions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        lifecycle.map(value => value.asEditable)
      )
    def targetBackupVault: Optional[NonEmptyString]
    def startWindowMinutes: Optional[Long]
    def scheduleExpression: Optional[NonEmptyString]
    def ruleName: Optional[NonEmptyString]
    def ruleId: Optional[NonEmptyString]
    def enableContinuousBackup: Optional[Boolean]
    def completionWindowMinutes: Optional[Long]
    def copyActions: Optional[List[
      zio.aws.securityhub.model.AwsBackupBackupPlanRuleCopyActionsDetails.ReadOnly
    ]]
    def lifecycle: Optional[
      zio.aws.securityhub.model.AwsBackupBackupPlanLifecycleDetails.ReadOnly
    ]
    def getTargetBackupVault: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("targetBackupVault", targetBackupVault)
    def getStartWindowMinutes: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("startWindowMinutes", startWindowMinutes)
    def getScheduleExpression: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("scheduleExpression", scheduleExpression)
    def getRuleName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("ruleName", ruleName)
    def getRuleId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("ruleId", ruleId)
    def getEnableContinuousBackup: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("enableContinuousBackup", enableContinuousBackup)
    def getCompletionWindowMinutes: ZIO[Any, AwsError, Long] = AwsError
      .unwrapOptionField("completionWindowMinutes", completionWindowMinutes)
    def getCopyActions: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsBackupBackupPlanRuleCopyActionsDetails.ReadOnly
    ]] = AwsError.unwrapOptionField("copyActions", copyActions)
    def getLifecycle: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsBackupBackupPlanLifecycleDetails.ReadOnly
    ] = AwsError.unwrapOptionField("lifecycle", lifecycle)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsBackupBackupPlanRuleDetails
  ) extends zio.aws.securityhub.model.AwsBackupBackupPlanRuleDetails.ReadOnly {
    override val targetBackupVault: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.targetBackupVault())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val startWindowMinutes: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.startWindowMinutes())
      .map(value => value: Long)
    override val scheduleExpression: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.scheduleExpression())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val ruleName: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.ruleName())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val ruleId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.ruleId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val enableContinuousBackup: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.enableContinuousBackup())
        .map(value => value: Boolean)
    override val completionWindowMinutes: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.completionWindowMinutes())
      .map(value => value: Long)
    override val copyActions: Optional[List[
      zio.aws.securityhub.model.AwsBackupBackupPlanRuleCopyActionsDetails.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.copyActions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsBackupBackupPlanRuleCopyActionsDetails
            .wrap(item)
        }.toList
      )
    override val lifecycle: Optional[
      zio.aws.securityhub.model.AwsBackupBackupPlanLifecycleDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.lifecycle())
      .map(value =>
        zio.aws.securityhub.model.AwsBackupBackupPlanLifecycleDetails
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsBackupBackupPlanRuleDetails
  ): zio.aws.securityhub.model.AwsBackupBackupPlanRuleDetails.ReadOnly =
    new Wrapper(impl)
}
