package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsApiGatewayCanarySettings(
    percentTraffic: Optional[Double] = Optional.Absent,
    deploymentId: Optional[NonEmptyString] = Optional.Absent,
    stageVariableOverrides: Optional[Map[NonEmptyString, NonEmptyString]] =
      Optional.Absent,
    useStageCache: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsApiGatewayCanarySettings = {
    import AwsApiGatewayCanarySettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsApiGatewayCanarySettings
      .builder()
      .optionallyWith(percentTraffic.map(value => value: java.lang.Double))(
        _.percentTraffic
      )
      .optionallyWith(
        deploymentId.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.deploymentId)
      .optionallyWith(
        stageVariableOverrides.map(value =>
          value
            .map({ case (key, value) =>
              (NonEmptyString.unwrap(key): java.lang.String) -> (NonEmptyString
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.stageVariableOverrides)
      .optionallyWith(useStageCache.map(value => value: java.lang.Boolean))(
        _.useStageCache
      )
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsApiGatewayCanarySettings.ReadOnly =
    zio.aws.securityhub.model.AwsApiGatewayCanarySettings.wrap(buildAwsValue())
}
object AwsApiGatewayCanarySettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsApiGatewayCanarySettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsApiGatewayCanarySettings =
      zio.aws.securityhub.model.AwsApiGatewayCanarySettings(
        percentTraffic.map(value => value),
        deploymentId.map(value => value),
        stageVariableOverrides.map(value => value),
        useStageCache.map(value => value)
      )
    def percentTraffic: Optional[Double]
    def deploymentId: Optional[NonEmptyString]
    def stageVariableOverrides: Optional[Map[NonEmptyString, NonEmptyString]]
    def useStageCache: Optional[Boolean]
    def getPercentTraffic: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("percentTraffic", percentTraffic)
    def getDeploymentId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("deploymentId", deploymentId)
    def getStageVariableOverrides
        : ZIO[Any, AwsError, Map[NonEmptyString, NonEmptyString]] = AwsError
      .unwrapOptionField("stageVariableOverrides", stageVariableOverrides)
    def getUseStageCache: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("useStageCache", useStageCache)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsApiGatewayCanarySettings
  ) extends zio.aws.securityhub.model.AwsApiGatewayCanarySettings.ReadOnly {
    override val percentTraffic: Optional[Double] = zio.aws.core.internal
      .optionalFromNullable(impl.percentTraffic())
      .map(value => value: Double)
    override val deploymentId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.deploymentId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val stageVariableOverrides
        : Optional[Map[NonEmptyString, NonEmptyString]] = zio.aws.core.internal
      .optionalFromNullable(impl.stageVariableOverrides())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.securityhub.model.primitives.NonEmptyString(
              key
            ) -> zio.aws.securityhub.model.primitives.NonEmptyString(value)
          })
          .toMap
      )
    override val useStageCache: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.useStageCache())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsApiGatewayCanarySettings
  ): zio.aws.securityhub.model.AwsApiGatewayCanarySettings.ReadOnly =
    new Wrapper(impl)
}
