package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ActionTarget(
    actionTargetArn: NonEmptyString,
    name: NonEmptyString,
    description: NonEmptyString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.ActionTarget = {
    import ActionTarget.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.ActionTarget
      .builder()
      .actionTargetArn(NonEmptyString.unwrap(actionTargetArn): java.lang.String)
      .name(NonEmptyString.unwrap(name): java.lang.String)
      .description(NonEmptyString.unwrap(description): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.ActionTarget.ReadOnly =
    zio.aws.securityhub.model.ActionTarget.wrap(buildAwsValue())
}
object ActionTarget {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.ActionTarget
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.ActionTarget =
      zio.aws.securityhub.model.ActionTarget(actionTargetArn, name, description)
    def actionTargetArn: NonEmptyString
    def name: NonEmptyString
    def description: NonEmptyString
    def getActionTargetArn: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(actionTargetArn)
    def getName: ZIO[Any, Nothing, NonEmptyString] = ZIO.succeed(name)
    def getDescription: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(description)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.ActionTarget
  ) extends zio.aws.securityhub.model.ActionTarget.ReadOnly {
    override val actionTargetArn: NonEmptyString =
      zio.aws.securityhub.model.primitives
        .NonEmptyString(impl.actionTargetArn())
    override val name: NonEmptyString =
      zio.aws.securityhub.model.primitives.NonEmptyString(impl.name())
    override val description: NonEmptyString =
      zio.aws.securityhub.model.primitives.NonEmptyString(impl.description())
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.ActionTarget
  ): zio.aws.securityhub.model.ActionTarget.ReadOnly = new Wrapper(impl)
}
