package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ActionLocalIpDetails(
    ipAddressV4: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.ActionLocalIpDetails = {
    import ActionLocalIpDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.ActionLocalIpDetails
      .builder()
      .optionallyWith(
        ipAddressV4.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.ipAddressV4)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.ActionLocalIpDetails.ReadOnly =
    zio.aws.securityhub.model.ActionLocalIpDetails.wrap(buildAwsValue())
}
object ActionLocalIpDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.ActionLocalIpDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.ActionLocalIpDetails =
      zio.aws.securityhub.model
        .ActionLocalIpDetails(ipAddressV4.map(value => value))
    def ipAddressV4: Optional[NonEmptyString]
    def getIpAddressV4: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("ipAddressV4", ipAddressV4)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.ActionLocalIpDetails
  ) extends zio.aws.securityhub.model.ActionLocalIpDetails.ReadOnly {
    override val ipAddressV4: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.ipAddressV4())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.ActionLocalIpDetails
  ): zio.aws.securityhub.model.ActionLocalIpDetails.ReadOnly = new Wrapper(impl)
}
