package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Workflow(
    status: Optional[zio.aws.securityhub.model.WorkflowStatus] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.Workflow = {
    import Workflow.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.Workflow
      .builder()
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.Workflow.ReadOnly =
    zio.aws.securityhub.model.Workflow.wrap(buildAwsValue())
}
object Workflow {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.Workflow
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.Workflow =
      zio.aws.securityhub.model.Workflow(status.map(value => value))
    def status: Optional[zio.aws.securityhub.model.WorkflowStatus]
    def getStatus
        : ZIO[Any, AwsError, zio.aws.securityhub.model.WorkflowStatus] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.Workflow
  ) extends zio.aws.securityhub.model.Workflow.ReadOnly {
    override val status: Optional[zio.aws.securityhub.model.WorkflowStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.securityhub.model.WorkflowStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.Workflow
  ): zio.aws.securityhub.model.Workflow.ReadOnly = new Wrapper(impl)
}
