package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateFindingAggregatorResponse(
    findingAggregatorArn: Optional[NonEmptyString] = Optional.Absent,
    findingAggregationRegion: Optional[NonEmptyString] = Optional.Absent,
    regionLinkingMode: Optional[NonEmptyString] = Optional.Absent,
    regions: Optional[Iterable[NonEmptyString]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.UpdateFindingAggregatorResponse = {
    import UpdateFindingAggregatorResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.UpdateFindingAggregatorResponse
      .builder()
      .optionallyWith(
        findingAggregatorArn.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.findingAggregatorArn)
      .optionallyWith(
        findingAggregationRegion.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.findingAggregationRegion)
      .optionallyWith(
        regionLinkingMode.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.regionLinkingMode)
      .optionallyWith(
        regions.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.regions)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.UpdateFindingAggregatorResponse.ReadOnly =
    zio.aws.securityhub.model.UpdateFindingAggregatorResponse
      .wrap(buildAwsValue())
}
object UpdateFindingAggregatorResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.UpdateFindingAggregatorResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.UpdateFindingAggregatorResponse =
      zio.aws.securityhub.model.UpdateFindingAggregatorResponse(
        findingAggregatorArn.map(value => value),
        findingAggregationRegion.map(value => value),
        regionLinkingMode.map(value => value),
        regions.map(value => value)
      )
    def findingAggregatorArn: Optional[NonEmptyString]
    def findingAggregationRegion: Optional[NonEmptyString]
    def regionLinkingMode: Optional[NonEmptyString]
    def regions: Optional[List[NonEmptyString]]
    def getFindingAggregatorArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("findingAggregatorArn", findingAggregatorArn)
    def getFindingAggregationRegion: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField(
        "findingAggregationRegion",
        findingAggregationRegion
      )
    def getRegionLinkingMode: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("regionLinkingMode", regionLinkingMode)
    def getRegions: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("regions", regions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.UpdateFindingAggregatorResponse
  ) extends zio.aws.securityhub.model.UpdateFindingAggregatorResponse.ReadOnly {
    override val findingAggregatorArn: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.findingAggregatorArn())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val findingAggregationRegion: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.findingAggregationRegion())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val regionLinkingMode: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.regionLinkingMode())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val regions: Optional[List[NonEmptyString]] = zio.aws.core.internal
      .optionalFromNullable(impl.regions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.primitives.NonEmptyString(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.UpdateFindingAggregatorResponse
  ): zio.aws.securityhub.model.UpdateFindingAggregatorResponse.ReadOnly =
    new Wrapper(impl)
}
