package zio.aws.securityhub.model
import scala.jdk.CollectionConverters._
sealed trait StandardsStatus {
  def unwrap: software.amazon.awssdk.services.securityhub.model.StandardsStatus
}
object StandardsStatus {
  def wrap(
      value: software.amazon.awssdk.services.securityhub.model.StandardsStatus
  ): zio.aws.securityhub.model.StandardsStatus = value match {
    case software.amazon.awssdk.services.securityhub.model.StandardsStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.securityhub.model.StandardsStatus.PENDING =>
      val r = PENDING
      r
    case software.amazon.awssdk.services.securityhub.model.StandardsStatus.READY =>
      val r = READY
      r
    case software.amazon.awssdk.services.securityhub.model.StandardsStatus.FAILED =>
      val r = FAILED
      r
    case software.amazon.awssdk.services.securityhub.model.StandardsStatus.DELETING =>
      val r = DELETING
      r
    case software.amazon.awssdk.services.securityhub.model.StandardsStatus.INCOMPLETE =>
      val r = INCOMPLETE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.securityhub.model.StandardsStatus {
    override def unwrap
        : software.amazon.awssdk.services.securityhub.model.StandardsStatus =
      software.amazon.awssdk.services.securityhub.model.StandardsStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object PENDING extends zio.aws.securityhub.model.StandardsStatus {
    override def unwrap
        : software.amazon.awssdk.services.securityhub.model.StandardsStatus =
      software.amazon.awssdk.services.securityhub.model.StandardsStatus.PENDING
  }
  case object READY extends zio.aws.securityhub.model.StandardsStatus {
    override def unwrap
        : software.amazon.awssdk.services.securityhub.model.StandardsStatus =
      software.amazon.awssdk.services.securityhub.model.StandardsStatus.READY
  }
  case object FAILED extends zio.aws.securityhub.model.StandardsStatus {
    override def unwrap
        : software.amazon.awssdk.services.securityhub.model.StandardsStatus =
      software.amazon.awssdk.services.securityhub.model.StandardsStatus.FAILED
  }
  case object DELETING extends zio.aws.securityhub.model.StandardsStatus {
    override def unwrap
        : software.amazon.awssdk.services.securityhub.model.StandardsStatus =
      software.amazon.awssdk.services.securityhub.model.StandardsStatus.DELETING
  }
  case object INCOMPLETE extends zio.aws.securityhub.model.StandardsStatus {
    override def unwrap
        : software.amazon.awssdk.services.securityhub.model.StandardsStatus =
      software.amazon.awssdk.services.securityhub.model.StandardsStatus.INCOMPLETE
  }
}
