package zio.aws.securityhub.model
import scala.jdk.CollectionConverters._
sealed trait SeverityRating {
  def unwrap: software.amazon.awssdk.services.securityhub.model.SeverityRating
}
object SeverityRating {
  def wrap(
      value: software.amazon.awssdk.services.securityhub.model.SeverityRating
  ): zio.aws.securityhub.model.SeverityRating = value match {
    case software.amazon.awssdk.services.securityhub.model.SeverityRating.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.securityhub.model.SeverityRating.LOW =>
      val r = LOW
      r
    case software.amazon.awssdk.services.securityhub.model.SeverityRating.MEDIUM =>
      val r = MEDIUM
      r
    case software.amazon.awssdk.services.securityhub.model.SeverityRating.HIGH =>
      val r = HIGH
      r
    case software.amazon.awssdk.services.securityhub.model.SeverityRating.CRITICAL =>
      val r = CRITICAL
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.securityhub.model.SeverityRating {
    override def unwrap
        : software.amazon.awssdk.services.securityhub.model.SeverityRating =
      software.amazon.awssdk.services.securityhub.model.SeverityRating.UNKNOWN_TO_SDK_VERSION
  }
  case object LOW extends zio.aws.securityhub.model.SeverityRating {
    override def unwrap
        : software.amazon.awssdk.services.securityhub.model.SeverityRating =
      software.amazon.awssdk.services.securityhub.model.SeverityRating.LOW
  }
  case object MEDIUM extends zio.aws.securityhub.model.SeverityRating {
    override def unwrap
        : software.amazon.awssdk.services.securityhub.model.SeverityRating =
      software.amazon.awssdk.services.securityhub.model.SeverityRating.MEDIUM
  }
  case object HIGH extends zio.aws.securityhub.model.SeverityRating {
    override def unwrap
        : software.amazon.awssdk.services.securityhub.model.SeverityRating =
      software.amazon.awssdk.services.securityhub.model.SeverityRating.HIGH
  }
  case object CRITICAL extends zio.aws.securityhub.model.SeverityRating {
    override def unwrap
        : software.amazon.awssdk.services.securityhub.model.SeverityRating =
      software.amazon.awssdk.services.securityhub.model.SeverityRating.CRITICAL
  }
}
