package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.Integer
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class RuleGroupSourceStatelessRuleMatchAttributes(
    destinationPorts: Optional[Iterable[
      zio.aws.securityhub.model.RuleGroupSourceStatelessRuleMatchAttributesDestinationPorts
    ]] = Optional.Absent,
    destinations: Optional[Iterable[
      zio.aws.securityhub.model.RuleGroupSourceStatelessRuleMatchAttributesDestinations
    ]] = Optional.Absent,
    protocols: Optional[Iterable[Integer]] = Optional.Absent,
    sourcePorts: Optional[Iterable[
      zio.aws.securityhub.model.RuleGroupSourceStatelessRuleMatchAttributesSourcePorts
    ]] = Optional.Absent,
    sources: Optional[Iterable[
      zio.aws.securityhub.model.RuleGroupSourceStatelessRuleMatchAttributesSources
    ]] = Optional.Absent,
    tcpFlags: Optional[Iterable[
      zio.aws.securityhub.model.RuleGroupSourceStatelessRuleMatchAttributesTcpFlags
    ]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.RuleGroupSourceStatelessRuleMatchAttributes = {
    import RuleGroupSourceStatelessRuleMatchAttributes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.RuleGroupSourceStatelessRuleMatchAttributes
      .builder()
      .optionallyWith(
        destinationPorts.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.destinationPorts)
      .optionallyWith(
        destinations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.destinations)
      .optionallyWith(
        protocols.map(value =>
          value.map { item =>
            item: java.lang.Integer
          }.asJavaCollection
        )
      )(_.protocols)
      .optionallyWith(
        sourcePorts.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.sourcePorts)
      .optionallyWith(
        sources.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.sources)
      .optionallyWith(
        tcpFlags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tcpFlags)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.RuleGroupSourceStatelessRuleMatchAttributes.ReadOnly =
    zio.aws.securityhub.model.RuleGroupSourceStatelessRuleMatchAttributes
      .wrap(buildAwsValue())
}
object RuleGroupSourceStatelessRuleMatchAttributes {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.RuleGroupSourceStatelessRuleMatchAttributes
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.RuleGroupSourceStatelessRuleMatchAttributes =
      zio.aws.securityhub.model.RuleGroupSourceStatelessRuleMatchAttributes(
        destinationPorts.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        destinations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        protocols.map(value => value),
        sourcePorts.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        sources.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        tcpFlags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def destinationPorts: Optional[List[
      zio.aws.securityhub.model.RuleGroupSourceStatelessRuleMatchAttributesDestinationPorts.ReadOnly
    ]]
    def destinations: Optional[List[
      zio.aws.securityhub.model.RuleGroupSourceStatelessRuleMatchAttributesDestinations.ReadOnly
    ]]
    def protocols: Optional[List[Integer]]
    def sourcePorts: Optional[List[
      zio.aws.securityhub.model.RuleGroupSourceStatelessRuleMatchAttributesSourcePorts.ReadOnly
    ]]
    def sources: Optional[List[
      zio.aws.securityhub.model.RuleGroupSourceStatelessRuleMatchAttributesSources.ReadOnly
    ]]
    def tcpFlags: Optional[List[
      zio.aws.securityhub.model.RuleGroupSourceStatelessRuleMatchAttributesTcpFlags.ReadOnly
    ]]
    def getDestinationPorts: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.RuleGroupSourceStatelessRuleMatchAttributesDestinationPorts.ReadOnly
    ]] = AwsError.unwrapOptionField("destinationPorts", destinationPorts)
    def getDestinations: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.RuleGroupSourceStatelessRuleMatchAttributesDestinations.ReadOnly
    ]] = AwsError.unwrapOptionField("destinations", destinations)
    def getProtocols: ZIO[Any, AwsError, List[Integer]] =
      AwsError.unwrapOptionField("protocols", protocols)
    def getSourcePorts: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.RuleGroupSourceStatelessRuleMatchAttributesSourcePorts.ReadOnly
    ]] = AwsError.unwrapOptionField("sourcePorts", sourcePorts)
    def getSources: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.RuleGroupSourceStatelessRuleMatchAttributesSources.ReadOnly
    ]] = AwsError.unwrapOptionField("sources", sources)
    def getTcpFlags: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.RuleGroupSourceStatelessRuleMatchAttributesTcpFlags.ReadOnly
    ]] = AwsError.unwrapOptionField("tcpFlags", tcpFlags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.RuleGroupSourceStatelessRuleMatchAttributes
  ) extends zio.aws.securityhub.model.RuleGroupSourceStatelessRuleMatchAttributes.ReadOnly {
    override val destinationPorts: Optional[List[
      zio.aws.securityhub.model.RuleGroupSourceStatelessRuleMatchAttributesDestinationPorts.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.destinationPorts())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.RuleGroupSourceStatelessRuleMatchAttributesDestinationPorts
            .wrap(item)
        }.toList
      )
    override val destinations: Optional[List[
      zio.aws.securityhub.model.RuleGroupSourceStatelessRuleMatchAttributesDestinations.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.destinations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.RuleGroupSourceStatelessRuleMatchAttributesDestinations
            .wrap(item)
        }.toList
      )
    override val protocols: Optional[List[Integer]] = zio.aws.core.internal
      .optionalFromNullable(impl.protocols())
      .map(value =>
        value.asScala.map { item =>
          item: Integer
        }.toList
      )
    override val sourcePorts: Optional[List[
      zio.aws.securityhub.model.RuleGroupSourceStatelessRuleMatchAttributesSourcePorts.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.sourcePorts())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.RuleGroupSourceStatelessRuleMatchAttributesSourcePorts
            .wrap(item)
        }.toList
      )
    override val sources: Optional[List[
      zio.aws.securityhub.model.RuleGroupSourceStatelessRuleMatchAttributesSources.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.sources())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.RuleGroupSourceStatelessRuleMatchAttributesSources
            .wrap(item)
        }.toList
      )
    override val tcpFlags: Optional[List[
      zio.aws.securityhub.model.RuleGroupSourceStatelessRuleMatchAttributesTcpFlags.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.tcpFlags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.RuleGroupSourceStatelessRuleMatchAttributesTcpFlags
            .wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.RuleGroupSourceStatelessRuleMatchAttributes
  ): zio.aws.securityhub.model.RuleGroupSourceStatelessRuleMatchAttributes.ReadOnly =
    new Wrapper(impl)
}
