package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.{Integer, NonEmptyString}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ProcessDetails(
    name: Optional[NonEmptyString] = Optional.Absent,
    path: Optional[NonEmptyString] = Optional.Absent,
    pid: Optional[Integer] = Optional.Absent,
    parentPid: Optional[Integer] = Optional.Absent,
    launchedAt: Optional[NonEmptyString] = Optional.Absent,
    terminatedAt: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.ProcessDetails = {
    import ProcessDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.ProcessDetails
      .builder()
      .optionallyWith(
        name.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        path.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.path)
      .optionallyWith(pid.map(value => value: java.lang.Integer))(_.pid)
      .optionallyWith(parentPid.map(value => value: java.lang.Integer))(
        _.parentPid
      )
      .optionallyWith(
        launchedAt.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.launchedAt)
      .optionallyWith(
        terminatedAt.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.terminatedAt)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.ProcessDetails.ReadOnly =
    zio.aws.securityhub.model.ProcessDetails.wrap(buildAwsValue())
}
object ProcessDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.ProcessDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.ProcessDetails =
      zio.aws.securityhub.model.ProcessDetails(
        name.map(value => value),
        path.map(value => value),
        pid.map(value => value),
        parentPid.map(value => value),
        launchedAt.map(value => value),
        terminatedAt.map(value => value)
      )
    def name: Optional[NonEmptyString]
    def path: Optional[NonEmptyString]
    def pid: Optional[Integer]
    def parentPid: Optional[Integer]
    def launchedAt: Optional[NonEmptyString]
    def terminatedAt: Optional[NonEmptyString]
    def getName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("name", name)
    def getPath: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("path", path)
    def getPid: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("pid", pid)
    def getParentPid: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("parentPid", parentPid)
    def getLaunchedAt: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("launchedAt", launchedAt)
    def getTerminatedAt: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("terminatedAt", terminatedAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.ProcessDetails
  ) extends zio.aws.securityhub.model.ProcessDetails.ReadOnly {
    override val name: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val path: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.path())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val pid: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.pid())
      .map(value => value: Integer)
    override val parentPid: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.parentPid())
      .map(value => value: Integer)
    override val launchedAt: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.launchedAt())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val terminatedAt: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.terminatedAt())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.ProcessDetails
  ): zio.aws.securityhub.model.ProcessDetails.ReadOnly = new Wrapper(impl)
}
