package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class NoteUpdate(text: NonEmptyString, updatedBy: NonEmptyString) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.NoteUpdate = {
    import NoteUpdate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.NoteUpdate
      .builder()
      .text(NonEmptyString.unwrap(text): java.lang.String)
      .updatedBy(NonEmptyString.unwrap(updatedBy): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.NoteUpdate.ReadOnly =
    zio.aws.securityhub.model.NoteUpdate.wrap(buildAwsValue())
}
object NoteUpdate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.NoteUpdate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.NoteUpdate =
      zio.aws.securityhub.model.NoteUpdate(text, updatedBy)
    def text: NonEmptyString
    def updatedBy: NonEmptyString
    def getText: ZIO[Any, Nothing, NonEmptyString] = ZIO.succeed(text)
    def getUpdatedBy: ZIO[Any, Nothing, NonEmptyString] = ZIO.succeed(updatedBy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.NoteUpdate
  ) extends zio.aws.securityhub.model.NoteUpdate.ReadOnly {
    override val text: NonEmptyString =
      zio.aws.securityhub.model.primitives.NonEmptyString(impl.text())
    override val updatedBy: NonEmptyString =
      zio.aws.securityhub.model.primitives.NonEmptyString(impl.updatedBy())
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.NoteUpdate
  ): zio.aws.securityhub.model.NoteUpdate.ReadOnly = new Wrapper(impl)
}
