package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListInvitationsResponse(
    invitations: Optional[Iterable[zio.aws.securityhub.model.Invitation]] =
      Optional.Absent,
    nextToken: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.ListInvitationsResponse = {
    import ListInvitationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.ListInvitationsResponse
      .builder()
      .optionallyWith(
        invitations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.invitations)
      .optionallyWith(
        nextToken.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.ListInvitationsResponse.ReadOnly =
    zio.aws.securityhub.model.ListInvitationsResponse.wrap(buildAwsValue())
}
object ListInvitationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.ListInvitationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.ListInvitationsResponse =
      zio.aws.securityhub.model.ListInvitationsResponse(
        invitations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def invitations
        : Optional[List[zio.aws.securityhub.model.Invitation.ReadOnly]]
    def nextToken: Optional[NonEmptyString]
    def getInvitations: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.Invitation.ReadOnly
    ]] = AwsError.unwrapOptionField("invitations", invitations)
    def getNextToken: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.ListInvitationsResponse
  ) extends zio.aws.securityhub.model.ListInvitationsResponse.ReadOnly {
    override val invitations
        : Optional[List[zio.aws.securityhub.model.Invitation.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.invitations())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.Invitation.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.ListInvitationsResponse
  ): zio.aws.securityhub.model.ListInvitationsResponse.ReadOnly = new Wrapper(
    impl
  )
}
