package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetEnabledStandardsResponse(
    standardsSubscriptions: Optional[
      Iterable[zio.aws.securityhub.model.StandardsSubscription]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.GetEnabledStandardsResponse = {
    import GetEnabledStandardsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.GetEnabledStandardsResponse
      .builder()
      .optionallyWith(
        standardsSubscriptions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.standardsSubscriptions)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.GetEnabledStandardsResponse.ReadOnly =
    zio.aws.securityhub.model.GetEnabledStandardsResponse.wrap(buildAwsValue())
}
object GetEnabledStandardsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.GetEnabledStandardsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.GetEnabledStandardsResponse =
      zio.aws.securityhub.model.GetEnabledStandardsResponse(
        standardsSubscriptions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def standardsSubscriptions: Optional[
      List[zio.aws.securityhub.model.StandardsSubscription.ReadOnly]
    ]
    def nextToken: Optional[NextToken]
    def getStandardsSubscriptions: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.StandardsSubscription.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "standardsSubscriptions",
      standardsSubscriptions
    )
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.GetEnabledStandardsResponse
  ) extends zio.aws.securityhub.model.GetEnabledStandardsResponse.ReadOnly {
    override val standardsSubscriptions: Optional[
      List[zio.aws.securityhub.model.StandardsSubscription.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.standardsSubscriptions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.StandardsSubscription.wrap(item)
        }.toList
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.securityhub.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.GetEnabledStandardsResponse
  ): zio.aws.securityhub.model.GetEnabledStandardsResponse.ReadOnly =
    new Wrapper(impl)
}
