package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class BatchEnableStandardsRequest(
    standardsSubscriptionRequests: Iterable[
      zio.aws.securityhub.model.StandardsSubscriptionRequest
    ]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.BatchEnableStandardsRequest = {
    import BatchEnableStandardsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.BatchEnableStandardsRequest
      .builder()
      .standardsSubscriptionRequests(standardsSubscriptionRequests.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.BatchEnableStandardsRequest.ReadOnly =
    zio.aws.securityhub.model.BatchEnableStandardsRequest.wrap(buildAwsValue())
}
object BatchEnableStandardsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.BatchEnableStandardsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.BatchEnableStandardsRequest =
      zio.aws.securityhub.model
        .BatchEnableStandardsRequest(standardsSubscriptionRequests.map { item =>
          item.asEditable
        })
    def standardsSubscriptionRequests
        : List[zio.aws.securityhub.model.StandardsSubscriptionRequest.ReadOnly]
    def getStandardsSubscriptionRequests: ZIO[Any, Nothing, List[
      zio.aws.securityhub.model.StandardsSubscriptionRequest.ReadOnly
    ]] = ZIO.succeed(standardsSubscriptionRequests)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.BatchEnableStandardsRequest
  ) extends zio.aws.securityhub.model.BatchEnableStandardsRequest.ReadOnly {
    override val standardsSubscriptionRequests: List[
      zio.aws.securityhub.model.StandardsSubscriptionRequest.ReadOnly
    ] = impl
      .standardsSubscriptionRequests()
      .asScala
      .map { item =>
        zio.aws.securityhub.model.StandardsSubscriptionRequest.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.BatchEnableStandardsRequest
  ): zio.aws.securityhub.model.BatchEnableStandardsRequest.ReadOnly =
    new Wrapper(impl)
}
