package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class BatchDisableStandardsRequest(
    standardsSubscriptionArns: Iterable[NonEmptyString]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.BatchDisableStandardsRequest = {
    import BatchDisableStandardsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.BatchDisableStandardsRequest
      .builder()
      .standardsSubscriptionArns(standardsSubscriptionArns.map { item =>
        NonEmptyString.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.BatchDisableStandardsRequest.ReadOnly =
    zio.aws.securityhub.model.BatchDisableStandardsRequest.wrap(buildAwsValue())
}
object BatchDisableStandardsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.BatchDisableStandardsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.BatchDisableStandardsRequest =
      zio.aws.securityhub.model
        .BatchDisableStandardsRequest(standardsSubscriptionArns)
    def standardsSubscriptionArns: List[NonEmptyString]
    def getStandardsSubscriptionArns: ZIO[Any, Nothing, List[NonEmptyString]] =
      ZIO.succeed(standardsSubscriptionArns)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.BatchDisableStandardsRequest
  ) extends zio.aws.securityhub.model.BatchDisableStandardsRequest.ReadOnly {
    override val standardsSubscriptionArns: List[NonEmptyString] = impl
      .standardsSubscriptionArns()
      .asScala
      .map { item =>
        zio.aws.securityhub.model.primitives.NonEmptyString(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.BatchDisableStandardsRequest
  ): zio.aws.securityhub.model.BatchDisableStandardsRequest.ReadOnly =
    new Wrapper(impl)
}
