package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.{Integer, NonEmptyString}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsSsmComplianceSummary(
    status: Optional[NonEmptyString] = Optional.Absent,
    compliantCriticalCount: Optional[Integer] = Optional.Absent,
    compliantHighCount: Optional[Integer] = Optional.Absent,
    compliantMediumCount: Optional[Integer] = Optional.Absent,
    executionType: Optional[NonEmptyString] = Optional.Absent,
    nonCompliantCriticalCount: Optional[Integer] = Optional.Absent,
    compliantInformationalCount: Optional[Integer] = Optional.Absent,
    nonCompliantInformationalCount: Optional[Integer] = Optional.Absent,
    compliantUnspecifiedCount: Optional[Integer] = Optional.Absent,
    nonCompliantLowCount: Optional[Integer] = Optional.Absent,
    nonCompliantHighCount: Optional[Integer] = Optional.Absent,
    compliantLowCount: Optional[Integer] = Optional.Absent,
    complianceType: Optional[NonEmptyString] = Optional.Absent,
    patchBaselineId: Optional[NonEmptyString] = Optional.Absent,
    overallSeverity: Optional[NonEmptyString] = Optional.Absent,
    nonCompliantMediumCount: Optional[Integer] = Optional.Absent,
    nonCompliantUnspecifiedCount: Optional[Integer] = Optional.Absent,
    patchGroup: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsSsmComplianceSummary = {
    import AwsSsmComplianceSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsSsmComplianceSummary
      .builder()
      .optionallyWith(
        status.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.status)
      .optionallyWith(
        compliantCriticalCount.map(value => value: java.lang.Integer)
      )(_.compliantCriticalCount)
      .optionallyWith(
        compliantHighCount.map(value => value: java.lang.Integer)
      )(_.compliantHighCount)
      .optionallyWith(
        compliantMediumCount.map(value => value: java.lang.Integer)
      )(_.compliantMediumCount)
      .optionallyWith(
        executionType.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.executionType)
      .optionallyWith(
        nonCompliantCriticalCount.map(value => value: java.lang.Integer)
      )(_.nonCompliantCriticalCount)
      .optionallyWith(
        compliantInformationalCount.map(value => value: java.lang.Integer)
      )(_.compliantInformationalCount)
      .optionallyWith(
        nonCompliantInformationalCount.map(value => value: java.lang.Integer)
      )(_.nonCompliantInformationalCount)
      .optionallyWith(
        compliantUnspecifiedCount.map(value => value: java.lang.Integer)
      )(_.compliantUnspecifiedCount)
      .optionallyWith(
        nonCompliantLowCount.map(value => value: java.lang.Integer)
      )(_.nonCompliantLowCount)
      .optionallyWith(
        nonCompliantHighCount.map(value => value: java.lang.Integer)
      )(_.nonCompliantHighCount)
      .optionallyWith(compliantLowCount.map(value => value: java.lang.Integer))(
        _.compliantLowCount
      )
      .optionallyWith(
        complianceType.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.complianceType)
      .optionallyWith(
        patchBaselineId.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.patchBaselineId)
      .optionallyWith(
        overallSeverity.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.overallSeverity)
      .optionallyWith(
        nonCompliantMediumCount.map(value => value: java.lang.Integer)
      )(_.nonCompliantMediumCount)
      .optionallyWith(
        nonCompliantUnspecifiedCount.map(value => value: java.lang.Integer)
      )(_.nonCompliantUnspecifiedCount)
      .optionallyWith(
        patchGroup.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.patchGroup)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.AwsSsmComplianceSummary.ReadOnly =
    zio.aws.securityhub.model.AwsSsmComplianceSummary.wrap(buildAwsValue())
}
object AwsSsmComplianceSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsSsmComplianceSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsSsmComplianceSummary =
      zio.aws.securityhub.model.AwsSsmComplianceSummary(
        status.map(value => value),
        compliantCriticalCount.map(value => value),
        compliantHighCount.map(value => value),
        compliantMediumCount.map(value => value),
        executionType.map(value => value),
        nonCompliantCriticalCount.map(value => value),
        compliantInformationalCount.map(value => value),
        nonCompliantInformationalCount.map(value => value),
        compliantUnspecifiedCount.map(value => value),
        nonCompliantLowCount.map(value => value),
        nonCompliantHighCount.map(value => value),
        compliantLowCount.map(value => value),
        complianceType.map(value => value),
        patchBaselineId.map(value => value),
        overallSeverity.map(value => value),
        nonCompliantMediumCount.map(value => value),
        nonCompliantUnspecifiedCount.map(value => value),
        patchGroup.map(value => value)
      )
    def status: Optional[NonEmptyString]
    def compliantCriticalCount: Optional[Integer]
    def compliantHighCount: Optional[Integer]
    def compliantMediumCount: Optional[Integer]
    def executionType: Optional[NonEmptyString]
    def nonCompliantCriticalCount: Optional[Integer]
    def compliantInformationalCount: Optional[Integer]
    def nonCompliantInformationalCount: Optional[Integer]
    def compliantUnspecifiedCount: Optional[Integer]
    def nonCompliantLowCount: Optional[Integer]
    def nonCompliantHighCount: Optional[Integer]
    def compliantLowCount: Optional[Integer]
    def complianceType: Optional[NonEmptyString]
    def patchBaselineId: Optional[NonEmptyString]
    def overallSeverity: Optional[NonEmptyString]
    def nonCompliantMediumCount: Optional[Integer]
    def nonCompliantUnspecifiedCount: Optional[Integer]
    def patchGroup: Optional[NonEmptyString]
    def getStatus: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("status", status)
    def getCompliantCriticalCount: ZIO[Any, AwsError, Integer] = AwsError
      .unwrapOptionField("compliantCriticalCount", compliantCriticalCount)
    def getCompliantHighCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("compliantHighCount", compliantHighCount)
    def getCompliantMediumCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("compliantMediumCount", compliantMediumCount)
    def getExecutionType: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("executionType", executionType)
    def getNonCompliantCriticalCount: ZIO[Any, AwsError, Integer] = AwsError
      .unwrapOptionField("nonCompliantCriticalCount", nonCompliantCriticalCount)
    def getCompliantInformationalCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField(
        "compliantInformationalCount",
        compliantInformationalCount
      )
    def getNonCompliantInformationalCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField(
        "nonCompliantInformationalCount",
        nonCompliantInformationalCount
      )
    def getCompliantUnspecifiedCount: ZIO[Any, AwsError, Integer] = AwsError
      .unwrapOptionField("compliantUnspecifiedCount", compliantUnspecifiedCount)
    def getNonCompliantLowCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("nonCompliantLowCount", nonCompliantLowCount)
    def getNonCompliantHighCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("nonCompliantHighCount", nonCompliantHighCount)
    def getCompliantLowCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("compliantLowCount", compliantLowCount)
    def getComplianceType: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("complianceType", complianceType)
    def getPatchBaselineId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("patchBaselineId", patchBaselineId)
    def getOverallSeverity: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("overallSeverity", overallSeverity)
    def getNonCompliantMediumCount: ZIO[Any, AwsError, Integer] = AwsError
      .unwrapOptionField("nonCompliantMediumCount", nonCompliantMediumCount)
    def getNonCompliantUnspecifiedCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField(
        "nonCompliantUnspecifiedCount",
        nonCompliantUnspecifiedCount
      )
    def getPatchGroup: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("patchGroup", patchGroup)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsSsmComplianceSummary
  ) extends zio.aws.securityhub.model.AwsSsmComplianceSummary.ReadOnly {
    override val status: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val compliantCriticalCount: Optional[Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.compliantCriticalCount())
        .map(value => value: Integer)
    override val compliantHighCount: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.compliantHighCount())
      .map(value => value: Integer)
    override val compliantMediumCount: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.compliantMediumCount())
      .map(value => value: Integer)
    override val executionType: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.executionType())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val nonCompliantCriticalCount: Optional[Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nonCompliantCriticalCount())
        .map(value => value: Integer)
    override val compliantInformationalCount: Optional[Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.compliantInformationalCount())
        .map(value => value: Integer)
    override val nonCompliantInformationalCount: Optional[Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nonCompliantInformationalCount())
        .map(value => value: Integer)
    override val compliantUnspecifiedCount: Optional[Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.compliantUnspecifiedCount())
        .map(value => value: Integer)
    override val nonCompliantLowCount: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.nonCompliantLowCount())
      .map(value => value: Integer)
    override val nonCompliantHighCount: Optional[Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nonCompliantHighCount())
        .map(value => value: Integer)
    override val compliantLowCount: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.compliantLowCount())
      .map(value => value: Integer)
    override val complianceType: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.complianceType())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val patchBaselineId: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.patchBaselineId())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val overallSeverity: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.overallSeverity())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val nonCompliantMediumCount: Optional[Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nonCompliantMediumCount())
        .map(value => value: Integer)
    override val nonCompliantUnspecifiedCount: Optional[Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nonCompliantUnspecifiedCount())
        .map(value => value: Integer)
    override val patchGroup: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.patchGroup())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsSsmComplianceSummary
  ): zio.aws.securityhub.model.AwsSsmComplianceSummary.ReadOnly = new Wrapper(
    impl
  )
}
