package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.{NonEmptyString, Integer}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsSqsQueueDetails(
    kmsDataKeyReusePeriodSeconds: Optional[Integer] = Optional.Absent,
    kmsMasterKeyId: Optional[NonEmptyString] = Optional.Absent,
    queueName: Optional[NonEmptyString] = Optional.Absent,
    deadLetterTargetArn: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsSqsQueueDetails = {
    import AwsSqsQueueDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsSqsQueueDetails
      .builder()
      .optionallyWith(
        kmsDataKeyReusePeriodSeconds.map(value => value: java.lang.Integer)
      )(_.kmsDataKeyReusePeriodSeconds)
      .optionallyWith(
        kmsMasterKeyId.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.kmsMasterKeyId)
      .optionallyWith(
        queueName.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.queueName)
      .optionallyWith(
        deadLetterTargetArn.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.deadLetterTargetArn)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.AwsSqsQueueDetails.ReadOnly =
    zio.aws.securityhub.model.AwsSqsQueueDetails.wrap(buildAwsValue())
}
object AwsSqsQueueDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsSqsQueueDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsSqsQueueDetails =
      zio.aws.securityhub.model.AwsSqsQueueDetails(
        kmsDataKeyReusePeriodSeconds.map(value => value),
        kmsMasterKeyId.map(value => value),
        queueName.map(value => value),
        deadLetterTargetArn.map(value => value)
      )
    def kmsDataKeyReusePeriodSeconds: Optional[Integer]
    def kmsMasterKeyId: Optional[NonEmptyString]
    def queueName: Optional[NonEmptyString]
    def deadLetterTargetArn: Optional[NonEmptyString]
    def getKmsDataKeyReusePeriodSeconds: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField(
        "kmsDataKeyReusePeriodSeconds",
        kmsDataKeyReusePeriodSeconds
      )
    def getKmsMasterKeyId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("kmsMasterKeyId", kmsMasterKeyId)
    def getQueueName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("queueName", queueName)
    def getDeadLetterTargetArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("deadLetterTargetArn", deadLetterTargetArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsSqsQueueDetails
  ) extends zio.aws.securityhub.model.AwsSqsQueueDetails.ReadOnly {
    override val kmsDataKeyReusePeriodSeconds: Optional[Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.kmsDataKeyReusePeriodSeconds())
        .map(value => value: Integer)
    override val kmsMasterKeyId: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.kmsMasterKeyId())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val queueName: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.queueName())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val deadLetterTargetArn: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deadLetterTargetArn())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsSqsQueueDetails
  ): zio.aws.securityhub.model.AwsSqsQueueDetails.ReadOnly = new Wrapper(impl)
}
