package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsS3BucketDetails(
    ownerId: Optional[NonEmptyString] = Optional.Absent,
    ownerName: Optional[NonEmptyString] = Optional.Absent,
    ownerAccountId: Optional[NonEmptyString] = Optional.Absent,
    createdAt: Optional[NonEmptyString] = Optional.Absent,
    serverSideEncryptionConfiguration: Optional[
      zio.aws.securityhub.model.AwsS3BucketServerSideEncryptionConfiguration
    ] = Optional.Absent,
    bucketLifecycleConfiguration: Optional[
      zio.aws.securityhub.model.AwsS3BucketBucketLifecycleConfigurationDetails
    ] = Optional.Absent,
    publicAccessBlockConfiguration: Optional[
      zio.aws.securityhub.model.AwsS3AccountPublicAccessBlockDetails
    ] = Optional.Absent,
    accessControlList: Optional[NonEmptyString] = Optional.Absent,
    bucketLoggingConfiguration: Optional[
      zio.aws.securityhub.model.AwsS3BucketLoggingConfiguration
    ] = Optional.Absent,
    bucketWebsiteConfiguration: Optional[
      zio.aws.securityhub.model.AwsS3BucketWebsiteConfiguration
    ] = Optional.Absent,
    bucketNotificationConfiguration: Optional[
      zio.aws.securityhub.model.AwsS3BucketNotificationConfiguration
    ] = Optional.Absent,
    bucketVersioningConfiguration: Optional[
      zio.aws.securityhub.model.AwsS3BucketBucketVersioningConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsS3BucketDetails = {
    import AwsS3BucketDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsS3BucketDetails
      .builder()
      .optionallyWith(
        ownerId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.ownerId)
      .optionallyWith(
        ownerName.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.ownerName)
      .optionallyWith(
        ownerAccountId.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.ownerAccountId)
      .optionallyWith(
        createdAt.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.createdAt)
      .optionallyWith(
        serverSideEncryptionConfiguration.map(value => value.buildAwsValue())
      )(_.serverSideEncryptionConfiguration)
      .optionallyWith(
        bucketLifecycleConfiguration.map(value => value.buildAwsValue())
      )(_.bucketLifecycleConfiguration)
      .optionallyWith(
        publicAccessBlockConfiguration.map(value => value.buildAwsValue())
      )(_.publicAccessBlockConfiguration)
      .optionallyWith(
        accessControlList.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.accessControlList)
      .optionallyWith(
        bucketLoggingConfiguration.map(value => value.buildAwsValue())
      )(_.bucketLoggingConfiguration)
      .optionallyWith(
        bucketWebsiteConfiguration.map(value => value.buildAwsValue())
      )(_.bucketWebsiteConfiguration)
      .optionallyWith(
        bucketNotificationConfiguration.map(value => value.buildAwsValue())
      )(_.bucketNotificationConfiguration)
      .optionallyWith(
        bucketVersioningConfiguration.map(value => value.buildAwsValue())
      )(_.bucketVersioningConfiguration)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.AwsS3BucketDetails.ReadOnly =
    zio.aws.securityhub.model.AwsS3BucketDetails.wrap(buildAwsValue())
}
object AwsS3BucketDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsS3BucketDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsS3BucketDetails =
      zio.aws.securityhub.model.AwsS3BucketDetails(
        ownerId.map(value => value),
        ownerName.map(value => value),
        ownerAccountId.map(value => value),
        createdAt.map(value => value),
        serverSideEncryptionConfiguration.map(value => value.asEditable),
        bucketLifecycleConfiguration.map(value => value.asEditable),
        publicAccessBlockConfiguration.map(value => value.asEditable),
        accessControlList.map(value => value),
        bucketLoggingConfiguration.map(value => value.asEditable),
        bucketWebsiteConfiguration.map(value => value.asEditable),
        bucketNotificationConfiguration.map(value => value.asEditable),
        bucketVersioningConfiguration.map(value => value.asEditable)
      )
    def ownerId: Optional[NonEmptyString]
    def ownerName: Optional[NonEmptyString]
    def ownerAccountId: Optional[NonEmptyString]
    def createdAt: Optional[NonEmptyString]
    def serverSideEncryptionConfiguration: Optional[
      zio.aws.securityhub.model.AwsS3BucketServerSideEncryptionConfiguration.ReadOnly
    ]
    def bucketLifecycleConfiguration: Optional[
      zio.aws.securityhub.model.AwsS3BucketBucketLifecycleConfigurationDetails.ReadOnly
    ]
    def publicAccessBlockConfiguration: Optional[
      zio.aws.securityhub.model.AwsS3AccountPublicAccessBlockDetails.ReadOnly
    ]
    def accessControlList: Optional[NonEmptyString]
    def bucketLoggingConfiguration: Optional[
      zio.aws.securityhub.model.AwsS3BucketLoggingConfiguration.ReadOnly
    ]
    def bucketWebsiteConfiguration: Optional[
      zio.aws.securityhub.model.AwsS3BucketWebsiteConfiguration.ReadOnly
    ]
    def bucketNotificationConfiguration: Optional[
      zio.aws.securityhub.model.AwsS3BucketNotificationConfiguration.ReadOnly
    ]
    def bucketVersioningConfiguration: Optional[
      zio.aws.securityhub.model.AwsS3BucketBucketVersioningConfiguration.ReadOnly
    ]
    def getOwnerId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("ownerId", ownerId)
    def getOwnerName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("ownerName", ownerName)
    def getOwnerAccountId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("ownerAccountId", ownerAccountId)
    def getCreatedAt: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getServerSideEncryptionConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsS3BucketServerSideEncryptionConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "serverSideEncryptionConfiguration",
      serverSideEncryptionConfiguration
    )
    def getBucketLifecycleConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsS3BucketBucketLifecycleConfigurationDetails.ReadOnly
    ] = AwsError.unwrapOptionField(
      "bucketLifecycleConfiguration",
      bucketLifecycleConfiguration
    )
    def getPublicAccessBlockConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsS3AccountPublicAccessBlockDetails.ReadOnly
    ] = AwsError.unwrapOptionField(
      "publicAccessBlockConfiguration",
      publicAccessBlockConfiguration
    )
    def getAccessControlList: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("accessControlList", accessControlList)
    def getBucketLoggingConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsS3BucketLoggingConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "bucketLoggingConfiguration",
      bucketLoggingConfiguration
    )
    def getBucketWebsiteConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsS3BucketWebsiteConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "bucketWebsiteConfiguration",
      bucketWebsiteConfiguration
    )
    def getBucketNotificationConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsS3BucketNotificationConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "bucketNotificationConfiguration",
      bucketNotificationConfiguration
    )
    def getBucketVersioningConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsS3BucketBucketVersioningConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "bucketVersioningConfiguration",
      bucketVersioningConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsS3BucketDetails
  ) extends zio.aws.securityhub.model.AwsS3BucketDetails.ReadOnly {
    override val ownerId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.ownerId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val ownerName: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.ownerName())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val ownerAccountId: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ownerAccountId())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val createdAt: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val serverSideEncryptionConfiguration: Optional[
      zio.aws.securityhub.model.AwsS3BucketServerSideEncryptionConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.serverSideEncryptionConfiguration())
      .map(value =>
        zio.aws.securityhub.model.AwsS3BucketServerSideEncryptionConfiguration
          .wrap(value)
      )
    override val bucketLifecycleConfiguration: Optional[
      zio.aws.securityhub.model.AwsS3BucketBucketLifecycleConfigurationDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.bucketLifecycleConfiguration())
      .map(value =>
        zio.aws.securityhub.model.AwsS3BucketBucketLifecycleConfigurationDetails
          .wrap(value)
      )
    override val publicAccessBlockConfiguration: Optional[
      zio.aws.securityhub.model.AwsS3AccountPublicAccessBlockDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.publicAccessBlockConfiguration())
      .map(value =>
        zio.aws.securityhub.model.AwsS3AccountPublicAccessBlockDetails
          .wrap(value)
      )
    override val accessControlList: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.accessControlList())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val bucketLoggingConfiguration: Optional[
      zio.aws.securityhub.model.AwsS3BucketLoggingConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.bucketLoggingConfiguration())
      .map(value =>
        zio.aws.securityhub.model.AwsS3BucketLoggingConfiguration.wrap(value)
      )
    override val bucketWebsiteConfiguration: Optional[
      zio.aws.securityhub.model.AwsS3BucketWebsiteConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.bucketWebsiteConfiguration())
      .map(value =>
        zio.aws.securityhub.model.AwsS3BucketWebsiteConfiguration.wrap(value)
      )
    override val bucketNotificationConfiguration: Optional[
      zio.aws.securityhub.model.AwsS3BucketNotificationConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.bucketNotificationConfiguration())
      .map(value =>
        zio.aws.securityhub.model.AwsS3BucketNotificationConfiguration
          .wrap(value)
      )
    override val bucketVersioningConfiguration: Optional[
      zio.aws.securityhub.model.AwsS3BucketBucketVersioningConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.bucketVersioningConfiguration())
      .map(value =>
        zio.aws.securityhub.model.AwsS3BucketBucketVersioningConfiguration
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsS3BucketDetails
  ): zio.aws.securityhub.model.AwsS3BucketDetails.ReadOnly = new Wrapper(impl)
}
