package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsRedshiftClusterElasticIpStatus(
    elasticIp: Optional[NonEmptyString] = Optional.Absent,
    status: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsRedshiftClusterElasticIpStatus = {
    import AwsRedshiftClusterElasticIpStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsRedshiftClusterElasticIpStatus
      .builder()
      .optionallyWith(
        elasticIp.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.elasticIp)
      .optionallyWith(
        status.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.status)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsRedshiftClusterElasticIpStatus.ReadOnly =
    zio.aws.securityhub.model.AwsRedshiftClusterElasticIpStatus
      .wrap(buildAwsValue())
}
object AwsRedshiftClusterElasticIpStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsRedshiftClusterElasticIpStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsRedshiftClusterElasticIpStatus =
      zio.aws.securityhub.model.AwsRedshiftClusterElasticIpStatus(
        elasticIp.map(value => value),
        status.map(value => value)
      )
    def elasticIp: Optional[NonEmptyString]
    def status: Optional[NonEmptyString]
    def getElasticIp: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("elasticIp", elasticIp)
    def getStatus: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsRedshiftClusterElasticIpStatus
  ) extends zio.aws.securityhub.model.AwsRedshiftClusterElasticIpStatus.ReadOnly {
    override val elasticIp: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.elasticIp())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val status: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsRedshiftClusterElasticIpStatus
  ): zio.aws.securityhub.model.AwsRedshiftClusterElasticIpStatus.ReadOnly =
    new Wrapper(impl)
}
