package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.{Integer, NonEmptyString}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsRdsDbInstanceEndpoint(
    address: Optional[NonEmptyString] = Optional.Absent,
    port: Optional[Integer] = Optional.Absent,
    hostedZoneId: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsRdsDbInstanceEndpoint = {
    import AwsRdsDbInstanceEndpoint.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsRdsDbInstanceEndpoint
      .builder()
      .optionallyWith(
        address.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.address)
      .optionallyWith(port.map(value => value: java.lang.Integer))(_.port)
      .optionallyWith(
        hostedZoneId.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.hostedZoneId)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.AwsRdsDbInstanceEndpoint.ReadOnly =
    zio.aws.securityhub.model.AwsRdsDbInstanceEndpoint.wrap(buildAwsValue())
}
object AwsRdsDbInstanceEndpoint {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsRdsDbInstanceEndpoint
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsRdsDbInstanceEndpoint =
      zio.aws.securityhub.model.AwsRdsDbInstanceEndpoint(
        address.map(value => value),
        port.map(value => value),
        hostedZoneId.map(value => value)
      )
    def address: Optional[NonEmptyString]
    def port: Optional[Integer]
    def hostedZoneId: Optional[NonEmptyString]
    def getAddress: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("address", address)
    def getPort: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("port", port)
    def getHostedZoneId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("hostedZoneId", hostedZoneId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsRdsDbInstanceEndpoint
  ) extends zio.aws.securityhub.model.AwsRdsDbInstanceEndpoint.ReadOnly {
    override val address: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.address())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val port: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.port())
      .map(value => value: Integer)
    override val hostedZoneId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.hostedZoneId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsRdsDbInstanceEndpoint
  ): zio.aws.securityhub.model.AwsRdsDbInstanceEndpoint.ReadOnly = new Wrapper(
    impl
  )
}
