package zio.aws.securityhub.model
import scala.jdk.CollectionConverters._
sealed trait AutoEnableStandards {
  def unwrap
      : software.amazon.awssdk.services.securityhub.model.AutoEnableStandards
}
object AutoEnableStandards {
  def wrap(
      value: software.amazon.awssdk.services.securityhub.model.AutoEnableStandards
  ): zio.aws.securityhub.model.AutoEnableStandards = value match {
    case software.amazon.awssdk.services.securityhub.model.AutoEnableStandards.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.securityhub.model.AutoEnableStandards.NONE =>
      val r = NONE
      r
    case software.amazon.awssdk.services.securityhub.model.AutoEnableStandards.DEFAULT =>
      val r = DEFAULT
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.securityhub.model.AutoEnableStandards {
    override def unwrap
        : software.amazon.awssdk.services.securityhub.model.AutoEnableStandards =
      software.amazon.awssdk.services.securityhub.model.AutoEnableStandards.UNKNOWN_TO_SDK_VERSION
  }
  case object NONE extends zio.aws.securityhub.model.AutoEnableStandards {
    override def unwrap
        : software.amazon.awssdk.services.securityhub.model.AutoEnableStandards =
      software.amazon.awssdk.services.securityhub.model.AutoEnableStandards.NONE
  }
  case object DEFAULT extends zio.aws.securityhub.model.AutoEnableStandards {
    override def unwrap
        : software.amazon.awssdk.services.securityhub.model.AutoEnableStandards =
      software.amazon.awssdk.services.securityhub.model.AutoEnableStandards.DEFAULT
  }
}
