package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateInsightRequest(
    insightArn: NonEmptyString,
    name: Optional[NonEmptyString] = Optional.Absent,
    filters: Optional[zio.aws.securityhub.model.AwsSecurityFindingFilters] =
      Optional.Absent,
    groupByAttribute: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.UpdateInsightRequest = {
    import UpdateInsightRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.UpdateInsightRequest
      .builder()
      .insightArn(NonEmptyString.unwrap(insightArn): java.lang.String)
      .optionallyWith(
        name.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(filters.map(value => value.buildAwsValue()))(_.filters)
      .optionallyWith(
        groupByAttribute.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.groupByAttribute)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.UpdateInsightRequest.ReadOnly =
    zio.aws.securityhub.model.UpdateInsightRequest.wrap(buildAwsValue())
}
object UpdateInsightRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.UpdateInsightRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.UpdateInsightRequest =
      zio.aws.securityhub.model.UpdateInsightRequest(
        insightArn,
        name.map(value => value),
        filters.map(value => value.asEditable),
        groupByAttribute.map(value => value)
      )
    def insightArn: NonEmptyString
    def name: Optional[NonEmptyString]
    def filters
        : Optional[zio.aws.securityhub.model.AwsSecurityFindingFilters.ReadOnly]
    def groupByAttribute: Optional[NonEmptyString]
    def getInsightArn: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(insightArn)
    def getName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("name", name)
    def getFilters: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsSecurityFindingFilters.ReadOnly
    ] = AwsError.unwrapOptionField("filters", filters)
    def getGroupByAttribute: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("groupByAttribute", groupByAttribute)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.UpdateInsightRequest
  ) extends zio.aws.securityhub.model.UpdateInsightRequest.ReadOnly {
    override val insightArn: NonEmptyString =
      zio.aws.securityhub.model.primitives.NonEmptyString(impl.insightArn())
    override val name: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val filters: Optional[
      zio.aws.securityhub.model.AwsSecurityFindingFilters.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.filters())
      .map(value =>
        zio.aws.securityhub.model.AwsSecurityFindingFilters.wrap(value)
      )
    override val groupByAttribute: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.groupByAttribute())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.UpdateInsightRequest
  ): zio.aws.securityhub.model.UpdateInsightRequest.ReadOnly = new Wrapper(impl)
}
