package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SensitiveDataResult(
    category: Optional[NonEmptyString] = Optional.Absent,
    detections: Optional[
      Iterable[zio.aws.securityhub.model.SensitiveDataDetections]
    ] = Optional.Absent,
    totalCount: Optional[Long] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.SensitiveDataResult = {
    import SensitiveDataResult.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.SensitiveDataResult
      .builder()
      .optionallyWith(
        category.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.category)
      .optionallyWith(
        detections.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.detections)
      .optionallyWith(totalCount.map(value => value: java.lang.Long))(
        _.totalCount
      )
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.SensitiveDataResult.ReadOnly =
    zio.aws.securityhub.model.SensitiveDataResult.wrap(buildAwsValue())
}
object SensitiveDataResult {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.SensitiveDataResult
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.SensitiveDataResult =
      zio.aws.securityhub.model.SensitiveDataResult(
        category.map(value => value),
        detections.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        totalCount.map(value => value)
      )
    def category: Optional[NonEmptyString]
    def detections: Optional[
      List[zio.aws.securityhub.model.SensitiveDataDetections.ReadOnly]
    ]
    def totalCount: Optional[Long]
    def getCategory: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("category", category)
    def getDetections: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.SensitiveDataDetections.ReadOnly
    ]] = AwsError.unwrapOptionField("detections", detections)
    def getTotalCount: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("totalCount", totalCount)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.SensitiveDataResult
  ) extends zio.aws.securityhub.model.SensitiveDataResult.ReadOnly {
    override val category: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.category())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val detections: Optional[
      List[zio.aws.securityhub.model.SensitiveDataDetections.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.detections())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.SensitiveDataDetections.wrap(item)
        }.toList
      )
    override val totalCount: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.totalCount())
      .map(value => value: Long)
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.SensitiveDataResult
  ): zio.aws.securityhub.model.SensitiveDataResult.ReadOnly = new Wrapper(impl)
}
