package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.Integer
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class RuleGroupSourceStatelessRulesDetails(
    priority: Optional[Integer] = Optional.Absent,
    ruleDefinition: Optional[
      zio.aws.securityhub.model.RuleGroupSourceStatelessRuleDefinition
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.RuleGroupSourceStatelessRulesDetails = {
    import RuleGroupSourceStatelessRulesDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.RuleGroupSourceStatelessRulesDetails
      .builder()
      .optionallyWith(priority.map(value => value: java.lang.Integer))(
        _.priority
      )
      .optionallyWith(ruleDefinition.map(value => value.buildAwsValue()))(
        _.ruleDefinition
      )
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.RuleGroupSourceStatelessRulesDetails.ReadOnly =
    zio.aws.securityhub.model.RuleGroupSourceStatelessRulesDetails
      .wrap(buildAwsValue())
}
object RuleGroupSourceStatelessRulesDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.RuleGroupSourceStatelessRulesDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.RuleGroupSourceStatelessRulesDetails =
      zio.aws.securityhub.model.RuleGroupSourceStatelessRulesDetails(
        priority.map(value => value),
        ruleDefinition.map(value => value.asEditable)
      )
    def priority: Optional[Integer]
    def ruleDefinition: Optional[
      zio.aws.securityhub.model.RuleGroupSourceStatelessRuleDefinition.ReadOnly
    ]
    def getPriority: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("priority", priority)
    def getRuleDefinition: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.RuleGroupSourceStatelessRuleDefinition.ReadOnly
    ] = AwsError.unwrapOptionField("ruleDefinition", ruleDefinition)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.RuleGroupSourceStatelessRulesDetails
  ) extends zio.aws.securityhub.model.RuleGroupSourceStatelessRulesDetails.ReadOnly {
    override val priority: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.priority())
      .map(value => value: Integer)
    override val ruleDefinition: Optional[
      zio.aws.securityhub.model.RuleGroupSourceStatelessRuleDefinition.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.ruleDefinition())
      .map(value =>
        zio.aws.securityhub.model.RuleGroupSourceStatelessRuleDefinition
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.RuleGroupSourceStatelessRulesDetails
  ): zio.aws.securityhub.model.RuleGroupSourceStatelessRulesDetails.ReadOnly =
    new Wrapper(impl)
}
