package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Remediation(
    recommendation: Optional[zio.aws.securityhub.model.Recommendation] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.Remediation = {
    import Remediation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.Remediation
      .builder()
      .optionallyWith(recommendation.map(value => value.buildAwsValue()))(
        _.recommendation
      )
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.Remediation.ReadOnly =
    zio.aws.securityhub.model.Remediation.wrap(buildAwsValue())
}
object Remediation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.Remediation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.Remediation =
      zio.aws.securityhub.model
        .Remediation(recommendation.map(value => value.asEditable))
    def recommendation
        : Optional[zio.aws.securityhub.model.Recommendation.ReadOnly]
    def getRecommendation: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.Recommendation.ReadOnly
    ] = AwsError.unwrapOptionField("recommendation", recommendation)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.Remediation
  ) extends zio.aws.securityhub.model.Remediation.ReadOnly {
    override val recommendation
        : Optional[zio.aws.securityhub.model.Recommendation.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.recommendation())
        .map(value => zio.aws.securityhub.model.Recommendation.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.Remediation
  ): zio.aws.securityhub.model.Remediation.ReadOnly = new Wrapper(impl)
}
