package zio.aws.securityhub.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.securityhub.model.primitives.{NextToken, CrossAccountMaxResults}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListMembersRequest(
    onlyAssociated: Optional[Boolean] = Optional.Absent,
    maxResults: Optional[CrossAccountMaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.ListMembersRequest = {
    import ListMembersRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.ListMembersRequest
      .builder()
      .optionallyWith(onlyAssociated.map(value => value: java.lang.Boolean))(
        _.onlyAssociated
      )
      .optionallyWith(
        maxResults.map(value => CrossAccountMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.ListMembersRequest.ReadOnly =
    zio.aws.securityhub.model.ListMembersRequest.wrap(buildAwsValue())
}
object ListMembersRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.ListMembersRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.ListMembersRequest =
      zio.aws.securityhub.model.ListMembersRequest(
        onlyAssociated.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def onlyAssociated: Optional[Boolean]
    def maxResults: Optional[CrossAccountMaxResults]
    def nextToken: Optional[NextToken]
    def getOnlyAssociated: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("onlyAssociated", onlyAssociated)
    def getMaxResults: ZIO[Any, AwsError, CrossAccountMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.ListMembersRequest
  ) extends zio.aws.securityhub.model.ListMembersRequest.ReadOnly {
    override val onlyAssociated: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.onlyAssociated())
      .map(value => value: Boolean)
    override val maxResults: Optional[CrossAccountMaxResults] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.securityhub.model.primitives.CrossAccountMaxResults(value)
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.securityhub.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.ListMembersRequest
  ): zio.aws.securityhub.model.ListMembersRequest.ReadOnly = new Wrapper(impl)
}
