package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetFindingAggregatorRequest(
    findingAggregatorArn: NonEmptyString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.GetFindingAggregatorRequest = {
    import GetFindingAggregatorRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.GetFindingAggregatorRequest
      .builder()
      .findingAggregatorArn(
        NonEmptyString.unwrap(findingAggregatorArn): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.GetFindingAggregatorRequest.ReadOnly =
    zio.aws.securityhub.model.GetFindingAggregatorRequest.wrap(buildAwsValue())
}
object GetFindingAggregatorRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.GetFindingAggregatorRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.GetFindingAggregatorRequest =
      zio.aws.securityhub.model
        .GetFindingAggregatorRequest(findingAggregatorArn)
    def findingAggregatorArn: NonEmptyString
    def getFindingAggregatorArn: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(findingAggregatorArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.GetFindingAggregatorRequest
  ) extends zio.aws.securityhub.model.GetFindingAggregatorRequest.ReadOnly {
    override val findingAggregatorArn: NonEmptyString =
      zio.aws.securityhub.model.primitives
        .NonEmptyString(impl.findingAggregatorArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.GetFindingAggregatorRequest
  ): zio.aws.securityhub.model.GetFindingAggregatorRequest.ReadOnly =
    new Wrapper(impl)
}
