package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteInvitationsResponse(
    unprocessedAccounts: Optional[Iterable[zio.aws.securityhub.model.Result]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.DeleteInvitationsResponse = {
    import DeleteInvitationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.DeleteInvitationsResponse
      .builder()
      .optionallyWith(
        unprocessedAccounts.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.unprocessedAccounts)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.DeleteInvitationsResponse.ReadOnly =
    zio.aws.securityhub.model.DeleteInvitationsResponse.wrap(buildAwsValue())
}
object DeleteInvitationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.DeleteInvitationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.DeleteInvitationsResponse =
      zio.aws.securityhub.model.DeleteInvitationsResponse(
        unprocessedAccounts.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def unprocessedAccounts
        : Optional[List[zio.aws.securityhub.model.Result.ReadOnly]]
    def getUnprocessedAccounts
        : ZIO[Any, AwsError, List[zio.aws.securityhub.model.Result.ReadOnly]] =
      AwsError.unwrapOptionField("unprocessedAccounts", unprocessedAccounts)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.DeleteInvitationsResponse
  ) extends zio.aws.securityhub.model.DeleteInvitationsResponse.ReadOnly {
    override val unprocessedAccounts
        : Optional[List[zio.aws.securityhub.model.Result.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.unprocessedAccounts())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.Result.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.DeleteInvitationsResponse
  ): zio.aws.securityhub.model.DeleteInvitationsResponse.ReadOnly = new Wrapper(
    impl
  )
}
