package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteActionTargetResponse(actionTargetArn: NonEmptyString) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.DeleteActionTargetResponse = {
    import DeleteActionTargetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.DeleteActionTargetResponse
      .builder()
      .actionTargetArn(NonEmptyString.unwrap(actionTargetArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.DeleteActionTargetResponse.ReadOnly =
    zio.aws.securityhub.model.DeleteActionTargetResponse.wrap(buildAwsValue())
}
object DeleteActionTargetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.DeleteActionTargetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.DeleteActionTargetResponse =
      zio.aws.securityhub.model.DeleteActionTargetResponse(actionTargetArn)
    def actionTargetArn: NonEmptyString
    def getActionTargetArn: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(actionTargetArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.DeleteActionTargetResponse
  ) extends zio.aws.securityhub.model.DeleteActionTargetResponse.ReadOnly {
    override val actionTargetArn: NonEmptyString =
      zio.aws.securityhub.model.primitives
        .NonEmptyString(impl.actionTargetArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.DeleteActionTargetResponse
  ): zio.aws.securityhub.model.DeleteActionTargetResponse.ReadOnly =
    new Wrapper(impl)
}
