package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DataClassificationDetails(
    detailedResultsLocation: Optional[NonEmptyString] = Optional.Absent,
    result: Optional[zio.aws.securityhub.model.ClassificationResult] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.DataClassificationDetails = {
    import DataClassificationDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.DataClassificationDetails
      .builder()
      .optionallyWith(
        detailedResultsLocation.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.detailedResultsLocation)
      .optionallyWith(result.map(value => value.buildAwsValue()))(_.result)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.DataClassificationDetails.ReadOnly =
    zio.aws.securityhub.model.DataClassificationDetails.wrap(buildAwsValue())
}
object DataClassificationDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.DataClassificationDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.DataClassificationDetails =
      zio.aws.securityhub.model.DataClassificationDetails(
        detailedResultsLocation.map(value => value),
        result.map(value => value.asEditable)
      )
    def detailedResultsLocation: Optional[NonEmptyString]
    def result
        : Optional[zio.aws.securityhub.model.ClassificationResult.ReadOnly]
    def getDetailedResultsLocation: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField(
        "detailedResultsLocation",
        detailedResultsLocation
      )
    def getResult: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.ClassificationResult.ReadOnly
    ] = AwsError.unwrapOptionField("result", result)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.DataClassificationDetails
  ) extends zio.aws.securityhub.model.DataClassificationDetails.ReadOnly {
    override val detailedResultsLocation: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.detailedResultsLocation())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val result
        : Optional[zio.aws.securityhub.model.ClassificationResult.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.result())
        .map(value =>
          zio.aws.securityhub.model.ClassificationResult.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.DataClassificationDetails
  ): zio.aws.securityhub.model.DataClassificationDetails.ReadOnly = new Wrapper(
    impl
  )
}
