package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsWafRuleGroupRulesActionDetails(
    `type`: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsWafRuleGroupRulesActionDetails = {
    import AwsWafRuleGroupRulesActionDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsWafRuleGroupRulesActionDetails
      .builder()
      .optionallyWith(
        `type`.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.`type`)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsWafRuleGroupRulesActionDetails.ReadOnly =
    zio.aws.securityhub.model.AwsWafRuleGroupRulesActionDetails
      .wrap(buildAwsValue())
}
object AwsWafRuleGroupRulesActionDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsWafRuleGroupRulesActionDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsWafRuleGroupRulesActionDetails =
      zio.aws.securityhub.model
        .AwsWafRuleGroupRulesActionDetails(`type`.map(value => value))
    def `type`: Optional[NonEmptyString]
    def getType: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("type", `type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsWafRuleGroupRulesActionDetails
  ) extends zio.aws.securityhub.model.AwsWafRuleGroupRulesActionDetails.ReadOnly {
    override val `type`: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.`type`())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsWafRuleGroupRulesActionDetails
  ): zio.aws.securityhub.model.AwsWafRuleGroupRulesActionDetails.ReadOnly =
    new Wrapper(impl)
}
