package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsWafRegionalRulePredicateListDetails(
    dataId: Optional[NonEmptyString] = Optional.Absent,
    negated: Optional[Boolean] = Optional.Absent,
    `type`: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsWafRegionalRulePredicateListDetails = {
    import AwsWafRegionalRulePredicateListDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsWafRegionalRulePredicateListDetails
      .builder()
      .optionallyWith(
        dataId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.dataId)
      .optionallyWith(negated.map(value => value: java.lang.Boolean))(_.negated)
      .optionallyWith(
        `type`.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.`type`)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsWafRegionalRulePredicateListDetails.ReadOnly =
    zio.aws.securityhub.model.AwsWafRegionalRulePredicateListDetails
      .wrap(buildAwsValue())
}
object AwsWafRegionalRulePredicateListDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsWafRegionalRulePredicateListDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsWafRegionalRulePredicateListDetails =
      zio.aws.securityhub.model.AwsWafRegionalRulePredicateListDetails(
        dataId.map(value => value),
        negated.map(value => value),
        `type`.map(value => value)
      )
    def dataId: Optional[NonEmptyString]
    def negated: Optional[Boolean]
    def `type`: Optional[NonEmptyString]
    def getDataId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("dataId", dataId)
    def getNegated: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("negated", negated)
    def getType: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("type", `type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsWafRegionalRulePredicateListDetails
  ) extends zio.aws.securityhub.model.AwsWafRegionalRulePredicateListDetails.ReadOnly {
    override val dataId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.dataId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val negated: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.negated())
      .map(value => value: Boolean)
    override val `type`: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.`type`())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsWafRegionalRulePredicateListDetails
  ): zio.aws.securityhub.model.AwsWafRegionalRulePredicateListDetails.ReadOnly =
    new Wrapper(impl)
}
