package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsWafRegionalRuleGroupDetails(
    metricName: Optional[NonEmptyString] = Optional.Absent,
    name: Optional[NonEmptyString] = Optional.Absent,
    ruleGroupId: Optional[NonEmptyString] = Optional.Absent,
    rules: Optional[
      Iterable[zio.aws.securityhub.model.AwsWafRegionalRuleGroupRulesDetails]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsWafRegionalRuleGroupDetails = {
    import AwsWafRegionalRuleGroupDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsWafRegionalRuleGroupDetails
      .builder()
      .optionallyWith(
        metricName.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.metricName)
      .optionallyWith(
        name.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        ruleGroupId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.ruleGroupId)
      .optionallyWith(
        rules.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.rules)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsWafRegionalRuleGroupDetails.ReadOnly =
    zio.aws.securityhub.model.AwsWafRegionalRuleGroupDetails
      .wrap(buildAwsValue())
}
object AwsWafRegionalRuleGroupDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsWafRegionalRuleGroupDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsWafRegionalRuleGroupDetails =
      zio.aws.securityhub.model.AwsWafRegionalRuleGroupDetails(
        metricName.map(value => value),
        name.map(value => value),
        ruleGroupId.map(value => value),
        rules.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def metricName: Optional[NonEmptyString]
    def name: Optional[NonEmptyString]
    def ruleGroupId: Optional[NonEmptyString]
    def rules: Optional[List[
      zio.aws.securityhub.model.AwsWafRegionalRuleGroupRulesDetails.ReadOnly
    ]]
    def getMetricName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("metricName", metricName)
    def getName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("name", name)
    def getRuleGroupId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("ruleGroupId", ruleGroupId)
    def getRules: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsWafRegionalRuleGroupRulesDetails.ReadOnly
    ]] = AwsError.unwrapOptionField("rules", rules)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsWafRegionalRuleGroupDetails
  ) extends zio.aws.securityhub.model.AwsWafRegionalRuleGroupDetails.ReadOnly {
    override val metricName: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.metricName())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val name: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val ruleGroupId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.ruleGroupId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val rules: Optional[List[
      zio.aws.securityhub.model.AwsWafRegionalRuleGroupRulesDetails.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.rules())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsWafRegionalRuleGroupRulesDetails
            .wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsWafRegionalRuleGroupDetails
  ): zio.aws.securityhub.model.AwsWafRegionalRuleGroupDetails.ReadOnly =
    new Wrapper(impl)
}
