package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateOperandsTagDetails(
    key: Optional[NonEmptyString] = Optional.Absent,
    value: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateOperandsTagDetails = {
    import AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateOperandsTagDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateOperandsTagDetails
      .builder()
      .optionallyWith(
        key.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.key)
      .optionallyWith(
        value.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.value)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateOperandsTagDetails.ReadOnly =
    zio.aws.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateOperandsTagDetails
      .wrap(buildAwsValue())
}
object AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateOperandsTagDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateOperandsTagDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateOperandsTagDetails =
      zio.aws.securityhub.model
        .AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateOperandsTagDetails(
          key.map(value => value),
          value.map(value => value)
        )
    def key: Optional[NonEmptyString]
    def value: Optional[NonEmptyString]
    def getKey: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("key", key)
    def getValue: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateOperandsTagDetails
  ) extends zio.aws.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateOperandsTagDetails.ReadOnly {
    override val key: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.key())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val value: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.value())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateOperandsTagDetails
  ): zio.aws.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateOperandsTagDetails.ReadOnly =
    new Wrapper(impl)
}
