package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.{Integer, NonEmptyString}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsS3BucketBucketLifecycleConfigurationRulesDetails(
    abortIncompleteMultipartUpload: Optional[
      zio.aws.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesAbortIncompleteMultipartUploadDetails
    ] = Optional.Absent,
    expirationDate: Optional[NonEmptyString] = Optional.Absent,
    expirationInDays: Optional[Integer] = Optional.Absent,
    expiredObjectDeleteMarker: Optional[Boolean] = Optional.Absent,
    filter: Optional[
      zio.aws.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesFilterDetails
    ] = Optional.Absent,
    id: Optional[NonEmptyString] = Optional.Absent,
    noncurrentVersionExpirationInDays: Optional[Integer] = Optional.Absent,
    noncurrentVersionTransitions: Optional[Iterable[
      zio.aws.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesNoncurrentVersionTransitionsDetails
    ]] = Optional.Absent,
    prefix: Optional[NonEmptyString] = Optional.Absent,
    status: Optional[NonEmptyString] = Optional.Absent,
    transitions: Optional[Iterable[
      zio.aws.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesTransitionsDetails
    ]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesDetails = {
    import AwsS3BucketBucketLifecycleConfigurationRulesDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesDetails
      .builder()
      .optionallyWith(
        abortIncompleteMultipartUpload.map(value => value.buildAwsValue())
      )(_.abortIncompleteMultipartUpload)
      .optionallyWith(
        expirationDate.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.expirationDate)
      .optionallyWith(expirationInDays.map(value => value: java.lang.Integer))(
        _.expirationInDays
      )
      .optionallyWith(
        expiredObjectDeleteMarker.map(value => value: java.lang.Boolean)
      )(_.expiredObjectDeleteMarker)
      .optionallyWith(filter.map(value => value.buildAwsValue()))(_.filter)
      .optionallyWith(
        id.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(
        noncurrentVersionExpirationInDays.map(value => value: java.lang.Integer)
      )(_.noncurrentVersionExpirationInDays)
      .optionallyWith(
        noncurrentVersionTransitions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.noncurrentVersionTransitions)
      .optionallyWith(
        prefix.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.prefix)
      .optionallyWith(
        status.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.status)
      .optionallyWith(
        transitions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.transitions)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesDetails.ReadOnly =
    zio.aws.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesDetails
      .wrap(buildAwsValue())
}
object AwsS3BucketBucketLifecycleConfigurationRulesDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesDetails =
      zio.aws.securityhub.model
        .AwsS3BucketBucketLifecycleConfigurationRulesDetails(
          abortIncompleteMultipartUpload.map(value => value.asEditable),
          expirationDate.map(value => value),
          expirationInDays.map(value => value),
          expiredObjectDeleteMarker.map(value => value),
          filter.map(value => value.asEditable),
          id.map(value => value),
          noncurrentVersionExpirationInDays.map(value => value),
          noncurrentVersionTransitions.map(value =>
            value.map { item =>
              item.asEditable
            }
          ),
          prefix.map(value => value),
          status.map(value => value),
          transitions.map(value =>
            value.map { item =>
              item.asEditable
            }
          )
        )
    def abortIncompleteMultipartUpload: Optional[
      zio.aws.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesAbortIncompleteMultipartUploadDetails.ReadOnly
    ]
    def expirationDate: Optional[NonEmptyString]
    def expirationInDays: Optional[Integer]
    def expiredObjectDeleteMarker: Optional[Boolean]
    def filter: Optional[
      zio.aws.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesFilterDetails.ReadOnly
    ]
    def id: Optional[NonEmptyString]
    def noncurrentVersionExpirationInDays: Optional[Integer]
    def noncurrentVersionTransitions: Optional[List[
      zio.aws.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesNoncurrentVersionTransitionsDetails.ReadOnly
    ]]
    def prefix: Optional[NonEmptyString]
    def status: Optional[NonEmptyString]
    def transitions: Optional[List[
      zio.aws.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesTransitionsDetails.ReadOnly
    ]]
    def getAbortIncompleteMultipartUpload: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesAbortIncompleteMultipartUploadDetails.ReadOnly
    ] = AwsError.unwrapOptionField(
      "abortIncompleteMultipartUpload",
      abortIncompleteMultipartUpload
    )
    def getExpirationDate: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("expirationDate", expirationDate)
    def getExpirationInDays: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("expirationInDays", expirationInDays)
    def getExpiredObjectDeleteMarker: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("expiredObjectDeleteMarker", expiredObjectDeleteMarker)
    def getFilter: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesFilterDetails.ReadOnly
    ] = AwsError.unwrapOptionField("filter", filter)
    def getId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("id", id)
    def getNoncurrentVersionExpirationInDays: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField(
        "noncurrentVersionExpirationInDays",
        noncurrentVersionExpirationInDays
      )
    def getNoncurrentVersionTransitions: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesNoncurrentVersionTransitionsDetails.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "noncurrentVersionTransitions",
      noncurrentVersionTransitions
    )
    def getPrefix: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("prefix", prefix)
    def getStatus: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("status", status)
    def getTransitions: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesTransitionsDetails.ReadOnly
    ]] = AwsError.unwrapOptionField("transitions", transitions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesDetails
  ) extends zio.aws.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesDetails.ReadOnly {
    override val abortIncompleteMultipartUpload: Optional[
      zio.aws.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesAbortIncompleteMultipartUploadDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.abortIncompleteMultipartUpload())
      .map(value =>
        zio.aws.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesAbortIncompleteMultipartUploadDetails
          .wrap(value)
      )
    override val expirationDate: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.expirationDate())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val expirationInDays: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.expirationInDays())
      .map(value => value: Integer)
    override val expiredObjectDeleteMarker: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.expiredObjectDeleteMarker())
        .map(value => value: Boolean)
    override val filter: Optional[
      zio.aws.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesFilterDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.filter())
      .map(value =>
        zio.aws.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesFilterDetails
          .wrap(value)
      )
    override val id: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val noncurrentVersionExpirationInDays: Optional[Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.noncurrentVersionExpirationInDays())
        .map(value => value: Integer)
    override val noncurrentVersionTransitions: Optional[List[
      zio.aws.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesNoncurrentVersionTransitionsDetails.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.noncurrentVersionTransitions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesNoncurrentVersionTransitionsDetails
            .wrap(item)
        }.toList
      )
    override val prefix: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.prefix())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val status: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val transitions: Optional[List[
      zio.aws.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesTransitionsDetails.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.transitions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesTransitionsDetails
            .wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesDetails
  ): zio.aws.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesDetails.ReadOnly =
    new Wrapper(impl)
}
