package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsOpenSearchServiceDomainDetails(
    arn: Optional[NonEmptyString] = Optional.Absent,
    accessPolicies: Optional[NonEmptyString] = Optional.Absent,
    domainName: Optional[NonEmptyString] = Optional.Absent,
    id: Optional[NonEmptyString] = Optional.Absent,
    domainEndpoint: Optional[NonEmptyString] = Optional.Absent,
    engineVersion: Optional[NonEmptyString] = Optional.Absent,
    encryptionAtRestOptions: Optional[
      zio.aws.securityhub.model.AwsOpenSearchServiceDomainEncryptionAtRestOptionsDetails
    ] = Optional.Absent,
    nodeToNodeEncryptionOptions: Optional[
      zio.aws.securityhub.model.AwsOpenSearchServiceDomainNodeToNodeEncryptionOptionsDetails
    ] = Optional.Absent,
    serviceSoftwareOptions: Optional[
      zio.aws.securityhub.model.AwsOpenSearchServiceDomainServiceSoftwareOptionsDetails
    ] = Optional.Absent,
    clusterConfig: Optional[
      zio.aws.securityhub.model.AwsOpenSearchServiceDomainClusterConfigDetails
    ] = Optional.Absent,
    domainEndpointOptions: Optional[
      zio.aws.securityhub.model.AwsOpenSearchServiceDomainDomainEndpointOptionsDetails
    ] = Optional.Absent,
    vpcOptions: Optional[
      zio.aws.securityhub.model.AwsOpenSearchServiceDomainVpcOptionsDetails
    ] = Optional.Absent,
    logPublishingOptions: Optional[
      zio.aws.securityhub.model.AwsOpenSearchServiceDomainLogPublishingOptionsDetails
    ] = Optional.Absent,
    domainEndpoints: Optional[Map[NonEmptyString, NonEmptyString]] =
      Optional.Absent,
    advancedSecurityOptions: Optional[
      zio.aws.securityhub.model.AwsOpenSearchServiceDomainAdvancedSecurityOptionsDetails
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsOpenSearchServiceDomainDetails = {
    import AwsOpenSearchServiceDomainDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsOpenSearchServiceDomainDetails
      .builder()
      .optionallyWith(
        arn.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        accessPolicies.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.accessPolicies)
      .optionallyWith(
        domainName.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.domainName)
      .optionallyWith(
        id.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(
        domainEndpoint.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.domainEndpoint)
      .optionallyWith(
        engineVersion.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.engineVersion)
      .optionallyWith(
        encryptionAtRestOptions.map(value => value.buildAwsValue())
      )(_.encryptionAtRestOptions)
      .optionallyWith(
        nodeToNodeEncryptionOptions.map(value => value.buildAwsValue())
      )(_.nodeToNodeEncryptionOptions)
      .optionallyWith(
        serviceSoftwareOptions.map(value => value.buildAwsValue())
      )(_.serviceSoftwareOptions)
      .optionallyWith(clusterConfig.map(value => value.buildAwsValue()))(
        _.clusterConfig
      )
      .optionallyWith(
        domainEndpointOptions.map(value => value.buildAwsValue())
      )(_.domainEndpointOptions)
      .optionallyWith(vpcOptions.map(value => value.buildAwsValue()))(
        _.vpcOptions
      )
      .optionallyWith(logPublishingOptions.map(value => value.buildAwsValue()))(
        _.logPublishingOptions
      )
      .optionallyWith(
        domainEndpoints.map(value =>
          value
            .map({ case (key, value) =>
              (NonEmptyString.unwrap(key): java.lang.String) -> (NonEmptyString
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.domainEndpoints)
      .optionallyWith(
        advancedSecurityOptions.map(value => value.buildAwsValue())
      )(_.advancedSecurityOptions)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsOpenSearchServiceDomainDetails.ReadOnly =
    zio.aws.securityhub.model.AwsOpenSearchServiceDomainDetails
      .wrap(buildAwsValue())
}
object AwsOpenSearchServiceDomainDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsOpenSearchServiceDomainDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsOpenSearchServiceDomainDetails =
      zio.aws.securityhub.model.AwsOpenSearchServiceDomainDetails(
        arn.map(value => value),
        accessPolicies.map(value => value),
        domainName.map(value => value),
        id.map(value => value),
        domainEndpoint.map(value => value),
        engineVersion.map(value => value),
        encryptionAtRestOptions.map(value => value.asEditable),
        nodeToNodeEncryptionOptions.map(value => value.asEditable),
        serviceSoftwareOptions.map(value => value.asEditable),
        clusterConfig.map(value => value.asEditable),
        domainEndpointOptions.map(value => value.asEditable),
        vpcOptions.map(value => value.asEditable),
        logPublishingOptions.map(value => value.asEditable),
        domainEndpoints.map(value => value),
        advancedSecurityOptions.map(value => value.asEditable)
      )
    def arn: Optional[NonEmptyString]
    def accessPolicies: Optional[NonEmptyString]
    def domainName: Optional[NonEmptyString]
    def id: Optional[NonEmptyString]
    def domainEndpoint: Optional[NonEmptyString]
    def engineVersion: Optional[NonEmptyString]
    def encryptionAtRestOptions: Optional[
      zio.aws.securityhub.model.AwsOpenSearchServiceDomainEncryptionAtRestOptionsDetails.ReadOnly
    ]
    def nodeToNodeEncryptionOptions: Optional[
      zio.aws.securityhub.model.AwsOpenSearchServiceDomainNodeToNodeEncryptionOptionsDetails.ReadOnly
    ]
    def serviceSoftwareOptions: Optional[
      zio.aws.securityhub.model.AwsOpenSearchServiceDomainServiceSoftwareOptionsDetails.ReadOnly
    ]
    def clusterConfig: Optional[
      zio.aws.securityhub.model.AwsOpenSearchServiceDomainClusterConfigDetails.ReadOnly
    ]
    def domainEndpointOptions: Optional[
      zio.aws.securityhub.model.AwsOpenSearchServiceDomainDomainEndpointOptionsDetails.ReadOnly
    ]
    def vpcOptions: Optional[
      zio.aws.securityhub.model.AwsOpenSearchServiceDomainVpcOptionsDetails.ReadOnly
    ]
    def logPublishingOptions: Optional[
      zio.aws.securityhub.model.AwsOpenSearchServiceDomainLogPublishingOptionsDetails.ReadOnly
    ]
    def domainEndpoints: Optional[Map[NonEmptyString, NonEmptyString]]
    def advancedSecurityOptions: Optional[
      zio.aws.securityhub.model.AwsOpenSearchServiceDomainAdvancedSecurityOptionsDetails.ReadOnly
    ]
    def getArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("arn", arn)
    def getAccessPolicies: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("accessPolicies", accessPolicies)
    def getDomainName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("domainName", domainName)
    def getId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("id", id)
    def getDomainEndpoint: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("domainEndpoint", domainEndpoint)
    def getEngineVersion: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("engineVersion", engineVersion)
    def getEncryptionAtRestOptions: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsOpenSearchServiceDomainEncryptionAtRestOptionsDetails.ReadOnly
    ] = AwsError.unwrapOptionField(
      "encryptionAtRestOptions",
      encryptionAtRestOptions
    )
    def getNodeToNodeEncryptionOptions: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsOpenSearchServiceDomainNodeToNodeEncryptionOptionsDetails.ReadOnly
    ] = AwsError.unwrapOptionField(
      "nodeToNodeEncryptionOptions",
      nodeToNodeEncryptionOptions
    )
    def getServiceSoftwareOptions: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsOpenSearchServiceDomainServiceSoftwareOptionsDetails.ReadOnly
    ] = AwsError.unwrapOptionField(
      "serviceSoftwareOptions",
      serviceSoftwareOptions
    )
    def getClusterConfig: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsOpenSearchServiceDomainClusterConfigDetails.ReadOnly
    ] = AwsError.unwrapOptionField("clusterConfig", clusterConfig)
    def getDomainEndpointOptions: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsOpenSearchServiceDomainDomainEndpointOptionsDetails.ReadOnly
    ] =
      AwsError.unwrapOptionField("domainEndpointOptions", domainEndpointOptions)
    def getVpcOptions: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsOpenSearchServiceDomainVpcOptionsDetails.ReadOnly
    ] = AwsError.unwrapOptionField("vpcOptions", vpcOptions)
    def getLogPublishingOptions: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsOpenSearchServiceDomainLogPublishingOptionsDetails.ReadOnly
    ] = AwsError.unwrapOptionField("logPublishingOptions", logPublishingOptions)
    def getDomainEndpoints
        : ZIO[Any, AwsError, Map[NonEmptyString, NonEmptyString]] =
      AwsError.unwrapOptionField("domainEndpoints", domainEndpoints)
    def getAdvancedSecurityOptions: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsOpenSearchServiceDomainAdvancedSecurityOptionsDetails.ReadOnly
    ] = AwsError.unwrapOptionField(
      "advancedSecurityOptions",
      advancedSecurityOptions
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsOpenSearchServiceDomainDetails
  ) extends zio.aws.securityhub.model.AwsOpenSearchServiceDomainDetails.ReadOnly {
    override val arn: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val accessPolicies: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.accessPolicies())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val domainName: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.domainName())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val id: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val domainEndpoint: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.domainEndpoint())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val engineVersion: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.engineVersion())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val encryptionAtRestOptions: Optional[
      zio.aws.securityhub.model.AwsOpenSearchServiceDomainEncryptionAtRestOptionsDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.encryptionAtRestOptions())
      .map(value =>
        zio.aws.securityhub.model.AwsOpenSearchServiceDomainEncryptionAtRestOptionsDetails
          .wrap(value)
      )
    override val nodeToNodeEncryptionOptions: Optional[
      zio.aws.securityhub.model.AwsOpenSearchServiceDomainNodeToNodeEncryptionOptionsDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.nodeToNodeEncryptionOptions())
      .map(value =>
        zio.aws.securityhub.model.AwsOpenSearchServiceDomainNodeToNodeEncryptionOptionsDetails
          .wrap(value)
      )
    override val serviceSoftwareOptions: Optional[
      zio.aws.securityhub.model.AwsOpenSearchServiceDomainServiceSoftwareOptionsDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.serviceSoftwareOptions())
      .map(value =>
        zio.aws.securityhub.model.AwsOpenSearchServiceDomainServiceSoftwareOptionsDetails
          .wrap(value)
      )
    override val clusterConfig: Optional[
      zio.aws.securityhub.model.AwsOpenSearchServiceDomainClusterConfigDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.clusterConfig())
      .map(value =>
        zio.aws.securityhub.model.AwsOpenSearchServiceDomainClusterConfigDetails
          .wrap(value)
      )
    override val domainEndpointOptions: Optional[
      zio.aws.securityhub.model.AwsOpenSearchServiceDomainDomainEndpointOptionsDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.domainEndpointOptions())
      .map(value =>
        zio.aws.securityhub.model.AwsOpenSearchServiceDomainDomainEndpointOptionsDetails
          .wrap(value)
      )
    override val vpcOptions: Optional[
      zio.aws.securityhub.model.AwsOpenSearchServiceDomainVpcOptionsDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcOptions())
      .map(value =>
        zio.aws.securityhub.model.AwsOpenSearchServiceDomainVpcOptionsDetails
          .wrap(value)
      )
    override val logPublishingOptions: Optional[
      zio.aws.securityhub.model.AwsOpenSearchServiceDomainLogPublishingOptionsDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.logPublishingOptions())
      .map(value =>
        zio.aws.securityhub.model.AwsOpenSearchServiceDomainLogPublishingOptionsDetails
          .wrap(value)
      )
    override val domainEndpoints
        : Optional[Map[NonEmptyString, NonEmptyString]] = zio.aws.core.internal
      .optionalFromNullable(impl.domainEndpoints())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.securityhub.model.primitives.NonEmptyString(
              key
            ) -> zio.aws.securityhub.model.primitives.NonEmptyString(value)
          })
          .toMap
      )
    override val advancedSecurityOptions: Optional[
      zio.aws.securityhub.model.AwsOpenSearchServiceDomainAdvancedSecurityOptionsDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.advancedSecurityOptions())
      .map(value =>
        zio.aws.securityhub.model.AwsOpenSearchServiceDomainAdvancedSecurityOptionsDetails
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsOpenSearchServiceDomainDetails
  ): zio.aws.securityhub.model.AwsOpenSearchServiceDomainDetails.ReadOnly =
    new Wrapper(impl)
}
