package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.{NonEmptyString, Integer}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsOpenSearchServiceDomainClusterConfigDetails(
    instanceCount: Optional[Integer] = Optional.Absent,
    warmEnabled: Optional[Boolean] = Optional.Absent,
    warmCount: Optional[Integer] = Optional.Absent,
    dedicatedMasterEnabled: Optional[Boolean] = Optional.Absent,
    zoneAwarenessConfig: Optional[
      zio.aws.securityhub.model.AwsOpenSearchServiceDomainClusterConfigZoneAwarenessConfigDetails
    ] = Optional.Absent,
    dedicatedMasterCount: Optional[Integer] = Optional.Absent,
    instanceType: Optional[NonEmptyString] = Optional.Absent,
    warmType: Optional[NonEmptyString] = Optional.Absent,
    zoneAwarenessEnabled: Optional[Boolean] = Optional.Absent,
    dedicatedMasterType: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsOpenSearchServiceDomainClusterConfigDetails = {
    import AwsOpenSearchServiceDomainClusterConfigDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsOpenSearchServiceDomainClusterConfigDetails
      .builder()
      .optionallyWith(instanceCount.map(value => value: java.lang.Integer))(
        _.instanceCount
      )
      .optionallyWith(warmEnabled.map(value => value: java.lang.Boolean))(
        _.warmEnabled
      )
      .optionallyWith(warmCount.map(value => value: java.lang.Integer))(
        _.warmCount
      )
      .optionallyWith(
        dedicatedMasterEnabled.map(value => value: java.lang.Boolean)
      )(_.dedicatedMasterEnabled)
      .optionallyWith(zoneAwarenessConfig.map(value => value.buildAwsValue()))(
        _.zoneAwarenessConfig
      )
      .optionallyWith(
        dedicatedMasterCount.map(value => value: java.lang.Integer)
      )(_.dedicatedMasterCount)
      .optionallyWith(
        instanceType.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.instanceType)
      .optionallyWith(
        warmType.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.warmType)
      .optionallyWith(
        zoneAwarenessEnabled.map(value => value: java.lang.Boolean)
      )(_.zoneAwarenessEnabled)
      .optionallyWith(
        dedicatedMasterType.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.dedicatedMasterType)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsOpenSearchServiceDomainClusterConfigDetails.ReadOnly =
    zio.aws.securityhub.model.AwsOpenSearchServiceDomainClusterConfigDetails
      .wrap(buildAwsValue())
}
object AwsOpenSearchServiceDomainClusterConfigDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsOpenSearchServiceDomainClusterConfigDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsOpenSearchServiceDomainClusterConfigDetails =
      zio.aws.securityhub.model.AwsOpenSearchServiceDomainClusterConfigDetails(
        instanceCount.map(value => value),
        warmEnabled.map(value => value),
        warmCount.map(value => value),
        dedicatedMasterEnabled.map(value => value),
        zoneAwarenessConfig.map(value => value.asEditable),
        dedicatedMasterCount.map(value => value),
        instanceType.map(value => value),
        warmType.map(value => value),
        zoneAwarenessEnabled.map(value => value),
        dedicatedMasterType.map(value => value)
      )
    def instanceCount: Optional[Integer]
    def warmEnabled: Optional[Boolean]
    def warmCount: Optional[Integer]
    def dedicatedMasterEnabled: Optional[Boolean]
    def zoneAwarenessConfig: Optional[
      zio.aws.securityhub.model.AwsOpenSearchServiceDomainClusterConfigZoneAwarenessConfigDetails.ReadOnly
    ]
    def dedicatedMasterCount: Optional[Integer]
    def instanceType: Optional[NonEmptyString]
    def warmType: Optional[NonEmptyString]
    def zoneAwarenessEnabled: Optional[Boolean]
    def dedicatedMasterType: Optional[NonEmptyString]
    def getInstanceCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("instanceCount", instanceCount)
    def getWarmEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("warmEnabled", warmEnabled)
    def getWarmCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("warmCount", warmCount)
    def getDedicatedMasterEnabled: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("dedicatedMasterEnabled", dedicatedMasterEnabled)
    def getZoneAwarenessConfig: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsOpenSearchServiceDomainClusterConfigZoneAwarenessConfigDetails.ReadOnly
    ] = AwsError.unwrapOptionField("zoneAwarenessConfig", zoneAwarenessConfig)
    def getDedicatedMasterCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("dedicatedMasterCount", dedicatedMasterCount)
    def getInstanceType: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("instanceType", instanceType)
    def getWarmType: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("warmType", warmType)
    def getZoneAwarenessEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("zoneAwarenessEnabled", zoneAwarenessEnabled)
    def getDedicatedMasterType: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("dedicatedMasterType", dedicatedMasterType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsOpenSearchServiceDomainClusterConfigDetails
  ) extends zio.aws.securityhub.model.AwsOpenSearchServiceDomainClusterConfigDetails.ReadOnly {
    override val instanceCount: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceCount())
      .map(value => value: Integer)
    override val warmEnabled: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.warmEnabled())
      .map(value => value: Boolean)
    override val warmCount: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.warmCount())
      .map(value => value: Integer)
    override val dedicatedMasterEnabled: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dedicatedMasterEnabled())
        .map(value => value: Boolean)
    override val zoneAwarenessConfig: Optional[
      zio.aws.securityhub.model.AwsOpenSearchServiceDomainClusterConfigZoneAwarenessConfigDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.zoneAwarenessConfig())
      .map(value =>
        zio.aws.securityhub.model.AwsOpenSearchServiceDomainClusterConfigZoneAwarenessConfigDetails
          .wrap(value)
      )
    override val dedicatedMasterCount: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.dedicatedMasterCount())
      .map(value => value: Integer)
    override val instanceType: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceType())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val warmType: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.warmType())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val zoneAwarenessEnabled: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.zoneAwarenessEnabled())
      .map(value => value: Boolean)
    override val dedicatedMasterType: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dedicatedMasterType())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsOpenSearchServiceDomainClusterConfigDetails
  ): zio.aws.securityhub.model.AwsOpenSearchServiceDomainClusterConfigDetails.ReadOnly =
    new Wrapper(impl)
}
