package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsKinesisStreamStreamEncryptionDetails(
    encryptionType: Optional[NonEmptyString] = Optional.Absent,
    keyId: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsKinesisStreamStreamEncryptionDetails = {
    import AwsKinesisStreamStreamEncryptionDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsKinesisStreamStreamEncryptionDetails
      .builder()
      .optionallyWith(
        encryptionType.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.encryptionType)
      .optionallyWith(
        keyId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.keyId)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsKinesisStreamStreamEncryptionDetails.ReadOnly =
    zio.aws.securityhub.model.AwsKinesisStreamStreamEncryptionDetails
      .wrap(buildAwsValue())
}
object AwsKinesisStreamStreamEncryptionDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsKinesisStreamStreamEncryptionDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsKinesisStreamStreamEncryptionDetails =
      zio.aws.securityhub.model.AwsKinesisStreamStreamEncryptionDetails(
        encryptionType.map(value => value),
        keyId.map(value => value)
      )
    def encryptionType: Optional[NonEmptyString]
    def keyId: Optional[NonEmptyString]
    def getEncryptionType: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("encryptionType", encryptionType)
    def getKeyId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("keyId", keyId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsKinesisStreamStreamEncryptionDetails
  ) extends zio.aws.securityhub.model.AwsKinesisStreamStreamEncryptionDetails.ReadOnly {
    override val encryptionType: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.encryptionType())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val keyId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.keyId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsKinesisStreamStreamEncryptionDetails
  ): zio.aws.securityhub.model.AwsKinesisStreamStreamEncryptionDetails.ReadOnly =
    new Wrapper(impl)
}
