package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsIamRolePolicy(
    policyName: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsIamRolePolicy = {
    import AwsIamRolePolicy.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsIamRolePolicy
      .builder()
      .optionallyWith(
        policyName.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.policyName)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.AwsIamRolePolicy.ReadOnly =
    zio.aws.securityhub.model.AwsIamRolePolicy.wrap(buildAwsValue())
}
object AwsIamRolePolicy {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsIamRolePolicy
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsIamRolePolicy =
      zio.aws.securityhub.model.AwsIamRolePolicy(policyName.map(value => value))
    def policyName: Optional[NonEmptyString]
    def getPolicyName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("policyName", policyName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsIamRolePolicy
  ) extends zio.aws.securityhub.model.AwsIamRolePolicy.ReadOnly {
    override val policyName: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.policyName())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsIamRolePolicy
  ): zio.aws.securityhub.model.AwsIamRolePolicy.ReadOnly = new Wrapper(impl)
}
