package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsIamGroupDetails(
    attachedManagedPolicies: Optional[
      Iterable[zio.aws.securityhub.model.AwsIamAttachedManagedPolicy]
    ] = Optional.Absent,
    createDate: Optional[NonEmptyString] = Optional.Absent,
    groupId: Optional[NonEmptyString] = Optional.Absent,
    groupName: Optional[NonEmptyString] = Optional.Absent,
    groupPolicyList: Optional[
      Iterable[zio.aws.securityhub.model.AwsIamGroupPolicy]
    ] = Optional.Absent,
    path: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsIamGroupDetails = {
    import AwsIamGroupDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsIamGroupDetails
      .builder()
      .optionallyWith(
        attachedManagedPolicies.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.attachedManagedPolicies)
      .optionallyWith(
        createDate.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.createDate)
      .optionallyWith(
        groupId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.groupId)
      .optionallyWith(
        groupName.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.groupName)
      .optionallyWith(
        groupPolicyList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.groupPolicyList)
      .optionallyWith(
        path.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.path)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.AwsIamGroupDetails.ReadOnly =
    zio.aws.securityhub.model.AwsIamGroupDetails.wrap(buildAwsValue())
}
object AwsIamGroupDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsIamGroupDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsIamGroupDetails =
      zio.aws.securityhub.model.AwsIamGroupDetails(
        attachedManagedPolicies.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        createDate.map(value => value),
        groupId.map(value => value),
        groupName.map(value => value),
        groupPolicyList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        path.map(value => value)
      )
    def attachedManagedPolicies: Optional[
      List[zio.aws.securityhub.model.AwsIamAttachedManagedPolicy.ReadOnly]
    ]
    def createDate: Optional[NonEmptyString]
    def groupId: Optional[NonEmptyString]
    def groupName: Optional[NonEmptyString]
    def groupPolicyList
        : Optional[List[zio.aws.securityhub.model.AwsIamGroupPolicy.ReadOnly]]
    def path: Optional[NonEmptyString]
    def getAttachedManagedPolicies: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsIamAttachedManagedPolicy.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "attachedManagedPolicies",
      attachedManagedPolicies
    )
    def getCreateDate: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("createDate", createDate)
    def getGroupId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("groupId", groupId)
    def getGroupName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("groupName", groupName)
    def getGroupPolicyList: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsIamGroupPolicy.ReadOnly
    ]] = AwsError.unwrapOptionField("groupPolicyList", groupPolicyList)
    def getPath: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("path", path)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsIamGroupDetails
  ) extends zio.aws.securityhub.model.AwsIamGroupDetails.ReadOnly {
    override val attachedManagedPolicies: Optional[
      List[zio.aws.securityhub.model.AwsIamAttachedManagedPolicy.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.attachedManagedPolicies())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsIamAttachedManagedPolicy.wrap(item)
        }.toList
      )
    override val createDate: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.createDate())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val groupId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.groupId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val groupName: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.groupName())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val groupPolicyList
        : Optional[List[zio.aws.securityhub.model.AwsIamGroupPolicy.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.groupPolicyList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.AwsIamGroupPolicy.wrap(item)
          }.toList
        )
    override val path: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.path())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsIamGroupDetails
  ): zio.aws.securityhub.model.AwsIamGroupDetails.ReadOnly = new Wrapper(impl)
}
