package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.{NonEmptyString, Integer}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsElbLoadBalancerListener(
    instancePort: Optional[Integer] = Optional.Absent,
    instanceProtocol: Optional[NonEmptyString] = Optional.Absent,
    loadBalancerPort: Optional[Integer] = Optional.Absent,
    protocol: Optional[NonEmptyString] = Optional.Absent,
    sslCertificateId: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsElbLoadBalancerListener = {
    import AwsElbLoadBalancerListener.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsElbLoadBalancerListener
      .builder()
      .optionallyWith(instancePort.map(value => value: java.lang.Integer))(
        _.instancePort
      )
      .optionallyWith(
        instanceProtocol.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.instanceProtocol)
      .optionallyWith(loadBalancerPort.map(value => value: java.lang.Integer))(
        _.loadBalancerPort
      )
      .optionallyWith(
        protocol.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.protocol)
      .optionallyWith(
        sslCertificateId.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.sslCertificateId)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsElbLoadBalancerListener.ReadOnly =
    zio.aws.securityhub.model.AwsElbLoadBalancerListener.wrap(buildAwsValue())
}
object AwsElbLoadBalancerListener {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsElbLoadBalancerListener
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsElbLoadBalancerListener =
      zio.aws.securityhub.model.AwsElbLoadBalancerListener(
        instancePort.map(value => value),
        instanceProtocol.map(value => value),
        loadBalancerPort.map(value => value),
        protocol.map(value => value),
        sslCertificateId.map(value => value)
      )
    def instancePort: Optional[Integer]
    def instanceProtocol: Optional[NonEmptyString]
    def loadBalancerPort: Optional[Integer]
    def protocol: Optional[NonEmptyString]
    def sslCertificateId: Optional[NonEmptyString]
    def getInstancePort: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("instancePort", instancePort)
    def getInstanceProtocol: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("instanceProtocol", instanceProtocol)
    def getLoadBalancerPort: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("loadBalancerPort", loadBalancerPort)
    def getProtocol: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("protocol", protocol)
    def getSslCertificateId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("sslCertificateId", sslCertificateId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsElbLoadBalancerListener
  ) extends zio.aws.securityhub.model.AwsElbLoadBalancerListener.ReadOnly {
    override val instancePort: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.instancePort())
      .map(value => value: Integer)
    override val instanceProtocol: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instanceProtocol())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val loadBalancerPort: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.loadBalancerPort())
      .map(value => value: Integer)
    override val protocol: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.protocol())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val sslCertificateId: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sslCertificateId())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsElbLoadBalancerListener
  ): zio.aws.securityhub.model.AwsElbLoadBalancerListener.ReadOnly =
    new Wrapper(impl)
}
