package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsElasticBeanstalkEnvironmentEnvironmentLink(
    environmentName: Optional[NonEmptyString] = Optional.Absent,
    linkName: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsElasticBeanstalkEnvironmentEnvironmentLink = {
    import AwsElasticBeanstalkEnvironmentEnvironmentLink.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsElasticBeanstalkEnvironmentEnvironmentLink
      .builder()
      .optionallyWith(
        environmentName.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.environmentName)
      .optionallyWith(
        linkName.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.linkName)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsElasticBeanstalkEnvironmentEnvironmentLink.ReadOnly =
    zio.aws.securityhub.model.AwsElasticBeanstalkEnvironmentEnvironmentLink
      .wrap(buildAwsValue())
}
object AwsElasticBeanstalkEnvironmentEnvironmentLink {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsElasticBeanstalkEnvironmentEnvironmentLink
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsElasticBeanstalkEnvironmentEnvironmentLink =
      zio.aws.securityhub.model.AwsElasticBeanstalkEnvironmentEnvironmentLink(
        environmentName.map(value => value),
        linkName.map(value => value)
      )
    def environmentName: Optional[NonEmptyString]
    def linkName: Optional[NonEmptyString]
    def getEnvironmentName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("environmentName", environmentName)
    def getLinkName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("linkName", linkName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsElasticBeanstalkEnvironmentEnvironmentLink
  ) extends zio.aws.securityhub.model.AwsElasticBeanstalkEnvironmentEnvironmentLink.ReadOnly {
    override val environmentName: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.environmentName())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val linkName: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.linkName())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsElasticBeanstalkEnvironmentEnvironmentLink
  ): zio.aws.securityhub.model.AwsElasticBeanstalkEnvironmentEnvironmentLink.ReadOnly =
    new Wrapper(impl)
}
