package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsEfsAccessPointPosixUserDetails(
    gid: Optional[NonEmptyString] = Optional.Absent,
    secondaryGids: Optional[Iterable[NonEmptyString]] = Optional.Absent,
    uid: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsEfsAccessPointPosixUserDetails = {
    import AwsEfsAccessPointPosixUserDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsEfsAccessPointPosixUserDetails
      .builder()
      .optionallyWith(
        gid.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.gid)
      .optionallyWith(
        secondaryGids.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.secondaryGids)
      .optionallyWith(
        uid.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.uid)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsEfsAccessPointPosixUserDetails.ReadOnly =
    zio.aws.securityhub.model.AwsEfsAccessPointPosixUserDetails
      .wrap(buildAwsValue())
}
object AwsEfsAccessPointPosixUserDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsEfsAccessPointPosixUserDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsEfsAccessPointPosixUserDetails =
      zio.aws.securityhub.model.AwsEfsAccessPointPosixUserDetails(
        gid.map(value => value),
        secondaryGids.map(value => value),
        uid.map(value => value)
      )
    def gid: Optional[NonEmptyString]
    def secondaryGids: Optional[List[NonEmptyString]]
    def uid: Optional[NonEmptyString]
    def getGid: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("gid", gid)
    def getSecondaryGids: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("secondaryGids", secondaryGids)
    def getUid: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("uid", uid)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEfsAccessPointPosixUserDetails
  ) extends zio.aws.securityhub.model.AwsEfsAccessPointPosixUserDetails.ReadOnly {
    override val gid: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.gid())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val secondaryGids: Optional[List[NonEmptyString]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.secondaryGids())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.primitives.NonEmptyString(item)
          }.toList
        )
    override val uid: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.uid())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEfsAccessPointPosixUserDetails
  ): zio.aws.securityhub.model.AwsEfsAccessPointPosixUserDetails.ReadOnly =
    new Wrapper(impl)
}
