package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsEcsTaskVolumeHostDetails(
    sourcePath: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsEcsTaskVolumeHostDetails = {
    import AwsEcsTaskVolumeHostDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsEcsTaskVolumeHostDetails
      .builder()
      .optionallyWith(
        sourcePath.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.sourcePath)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsEcsTaskVolumeHostDetails.ReadOnly =
    zio.aws.securityhub.model.AwsEcsTaskVolumeHostDetails.wrap(buildAwsValue())
}
object AwsEcsTaskVolumeHostDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsEcsTaskVolumeHostDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsEcsTaskVolumeHostDetails =
      zio.aws.securityhub.model
        .AwsEcsTaskVolumeHostDetails(sourcePath.map(value => value))
    def sourcePath: Optional[NonEmptyString]
    def getSourcePath: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("sourcePath", sourcePath)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEcsTaskVolumeHostDetails
  ) extends zio.aws.securityhub.model.AwsEcsTaskVolumeHostDetails.ReadOnly {
    override val sourcePath: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.sourcePath())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEcsTaskVolumeHostDetails
  ): zio.aws.securityhub.model.AwsEcsTaskVolumeHostDetails.ReadOnly =
    new Wrapper(impl)
}
