package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsEcsServiceDeploymentControllerDetails(
    `type`: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsEcsServiceDeploymentControllerDetails = {
    import AwsEcsServiceDeploymentControllerDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsEcsServiceDeploymentControllerDetails
      .builder()
      .optionallyWith(
        `type`.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.`type`)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsEcsServiceDeploymentControllerDetails.ReadOnly =
    zio.aws.securityhub.model.AwsEcsServiceDeploymentControllerDetails
      .wrap(buildAwsValue())
}
object AwsEcsServiceDeploymentControllerDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsEcsServiceDeploymentControllerDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsEcsServiceDeploymentControllerDetails =
      zio.aws.securityhub.model
        .AwsEcsServiceDeploymentControllerDetails(`type`.map(value => value))
    def `type`: Optional[NonEmptyString]
    def getType: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("type", `type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEcsServiceDeploymentControllerDetails
  ) extends zio.aws.securityhub.model.AwsEcsServiceDeploymentControllerDetails.ReadOnly {
    override val `type`: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.`type`())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEcsServiceDeploymentControllerDetails
  ): zio.aws.securityhub.model.AwsEcsServiceDeploymentControllerDetails.ReadOnly =
    new Wrapper(impl)
}
