package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsEc2VpnConnectionOptionsDetails(
    staticRoutesOnly: Optional[Boolean] = Optional.Absent,
    tunnelOptions: Optional[Iterable[
      zio.aws.securityhub.model.AwsEc2VpnConnectionOptionsTunnelOptionsDetails
    ]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsEc2VpnConnectionOptionsDetails = {
    import AwsEc2VpnConnectionOptionsDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsEc2VpnConnectionOptionsDetails
      .builder()
      .optionallyWith(staticRoutesOnly.map(value => value: java.lang.Boolean))(
        _.staticRoutesOnly
      )
      .optionallyWith(
        tunnelOptions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tunnelOptions)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsEc2VpnConnectionOptionsDetails.ReadOnly =
    zio.aws.securityhub.model.AwsEc2VpnConnectionOptionsDetails
      .wrap(buildAwsValue())
}
object AwsEc2VpnConnectionOptionsDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsEc2VpnConnectionOptionsDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsEc2VpnConnectionOptionsDetails =
      zio.aws.securityhub.model.AwsEc2VpnConnectionOptionsDetails(
        staticRoutesOnly.map(value => value),
        tunnelOptions.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def staticRoutesOnly: Optional[Boolean]
    def tunnelOptions: Optional[List[
      zio.aws.securityhub.model.AwsEc2VpnConnectionOptionsTunnelOptionsDetails.ReadOnly
    ]]
    def getStaticRoutesOnly: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("staticRoutesOnly", staticRoutesOnly)
    def getTunnelOptions: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsEc2VpnConnectionOptionsTunnelOptionsDetails.ReadOnly
    ]] = AwsError.unwrapOptionField("tunnelOptions", tunnelOptions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEc2VpnConnectionOptionsDetails
  ) extends zio.aws.securityhub.model.AwsEc2VpnConnectionOptionsDetails.ReadOnly {
    override val staticRoutesOnly: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.staticRoutesOnly())
      .map(value => value: Boolean)
    override val tunnelOptions: Optional[List[
      zio.aws.securityhub.model.AwsEc2VpnConnectionOptionsTunnelOptionsDetails.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.tunnelOptions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsEc2VpnConnectionOptionsTunnelOptionsDetails
            .wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEc2VpnConnectionOptionsDetails
  ): zio.aws.securityhub.model.AwsEc2VpnConnectionOptionsDetails.ReadOnly =
    new Wrapper(impl)
}
