package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsEc2VpcPeeringConnectionStatusDetails(
    code: Optional[NonEmptyString] = Optional.Absent,
    message: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsEc2VpcPeeringConnectionStatusDetails = {
    import AwsEc2VpcPeeringConnectionStatusDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsEc2VpcPeeringConnectionStatusDetails
      .builder()
      .optionallyWith(
        code.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.code)
      .optionallyWith(
        message.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.message)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsEc2VpcPeeringConnectionStatusDetails.ReadOnly =
    zio.aws.securityhub.model.AwsEc2VpcPeeringConnectionStatusDetails
      .wrap(buildAwsValue())
}
object AwsEc2VpcPeeringConnectionStatusDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsEc2VpcPeeringConnectionStatusDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsEc2VpcPeeringConnectionStatusDetails =
      zio.aws.securityhub.model.AwsEc2VpcPeeringConnectionStatusDetails(
        code.map(value => value),
        message.map(value => value)
      )
    def code: Optional[NonEmptyString]
    def message: Optional[NonEmptyString]
    def getCode: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("code", code)
    def getMessage: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("message", message)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEc2VpcPeeringConnectionStatusDetails
  ) extends zio.aws.securityhub.model.AwsEc2VpcPeeringConnectionStatusDetails.ReadOnly {
    override val code: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.code())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val message: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.message())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEc2VpcPeeringConnectionStatusDetails
  ): zio.aws.securityhub.model.AwsEc2VpcPeeringConnectionStatusDetails.ReadOnly =
    new Wrapper(impl)
}
