package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsCloudTrailTrailDetails(
    cloudWatchLogsLogGroupArn: Optional[NonEmptyString] = Optional.Absent,
    cloudWatchLogsRoleArn: Optional[NonEmptyString] = Optional.Absent,
    hasCustomEventSelectors: Optional[Boolean] = Optional.Absent,
    homeRegion: Optional[NonEmptyString] = Optional.Absent,
    includeGlobalServiceEvents: Optional[Boolean] = Optional.Absent,
    isMultiRegionTrail: Optional[Boolean] = Optional.Absent,
    isOrganizationTrail: Optional[Boolean] = Optional.Absent,
    kmsKeyId: Optional[NonEmptyString] = Optional.Absent,
    logFileValidationEnabled: Optional[Boolean] = Optional.Absent,
    name: Optional[NonEmptyString] = Optional.Absent,
    s3BucketName: Optional[NonEmptyString] = Optional.Absent,
    s3KeyPrefix: Optional[NonEmptyString] = Optional.Absent,
    snsTopicArn: Optional[NonEmptyString] = Optional.Absent,
    snsTopicName: Optional[NonEmptyString] = Optional.Absent,
    trailArn: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsCloudTrailTrailDetails = {
    import AwsCloudTrailTrailDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsCloudTrailTrailDetails
      .builder()
      .optionallyWith(
        cloudWatchLogsLogGroupArn.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.cloudWatchLogsLogGroupArn)
      .optionallyWith(
        cloudWatchLogsRoleArn.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.cloudWatchLogsRoleArn)
      .optionallyWith(
        hasCustomEventSelectors.map(value => value: java.lang.Boolean)
      )(_.hasCustomEventSelectors)
      .optionallyWith(
        homeRegion.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.homeRegion)
      .optionallyWith(
        includeGlobalServiceEvents.map(value => value: java.lang.Boolean)
      )(_.includeGlobalServiceEvents)
      .optionallyWith(
        isMultiRegionTrail.map(value => value: java.lang.Boolean)
      )(_.isMultiRegionTrail)
      .optionallyWith(
        isOrganizationTrail.map(value => value: java.lang.Boolean)
      )(_.isOrganizationTrail)
      .optionallyWith(
        kmsKeyId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.kmsKeyId)
      .optionallyWith(
        logFileValidationEnabled.map(value => value: java.lang.Boolean)
      )(_.logFileValidationEnabled)
      .optionallyWith(
        name.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        s3BucketName.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.s3BucketName)
      .optionallyWith(
        s3KeyPrefix.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.s3KeyPrefix)
      .optionallyWith(
        snsTopicArn.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.snsTopicArn)
      .optionallyWith(
        snsTopicName.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.snsTopicName)
      .optionallyWith(
        trailArn.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.trailArn)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.AwsCloudTrailTrailDetails.ReadOnly =
    zio.aws.securityhub.model.AwsCloudTrailTrailDetails.wrap(buildAwsValue())
}
object AwsCloudTrailTrailDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsCloudTrailTrailDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsCloudTrailTrailDetails =
      zio.aws.securityhub.model.AwsCloudTrailTrailDetails(
        cloudWatchLogsLogGroupArn.map(value => value),
        cloudWatchLogsRoleArn.map(value => value),
        hasCustomEventSelectors.map(value => value),
        homeRegion.map(value => value),
        includeGlobalServiceEvents.map(value => value),
        isMultiRegionTrail.map(value => value),
        isOrganizationTrail.map(value => value),
        kmsKeyId.map(value => value),
        logFileValidationEnabled.map(value => value),
        name.map(value => value),
        s3BucketName.map(value => value),
        s3KeyPrefix.map(value => value),
        snsTopicArn.map(value => value),
        snsTopicName.map(value => value),
        trailArn.map(value => value)
      )
    def cloudWatchLogsLogGroupArn: Optional[NonEmptyString]
    def cloudWatchLogsRoleArn: Optional[NonEmptyString]
    def hasCustomEventSelectors: Optional[Boolean]
    def homeRegion: Optional[NonEmptyString]
    def includeGlobalServiceEvents: Optional[Boolean]
    def isMultiRegionTrail: Optional[Boolean]
    def isOrganizationTrail: Optional[Boolean]
    def kmsKeyId: Optional[NonEmptyString]
    def logFileValidationEnabled: Optional[Boolean]
    def name: Optional[NonEmptyString]
    def s3BucketName: Optional[NonEmptyString]
    def s3KeyPrefix: Optional[NonEmptyString]
    def snsTopicArn: Optional[NonEmptyString]
    def snsTopicName: Optional[NonEmptyString]
    def trailArn: Optional[NonEmptyString]
    def getCloudWatchLogsLogGroupArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField(
        "cloudWatchLogsLogGroupArn",
        cloudWatchLogsLogGroupArn
      )
    def getCloudWatchLogsRoleArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("cloudWatchLogsRoleArn", cloudWatchLogsRoleArn)
    def getHasCustomEventSelectors: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("hasCustomEventSelectors", hasCustomEventSelectors)
    def getHomeRegion: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("homeRegion", homeRegion)
    def getIncludeGlobalServiceEvents: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "includeGlobalServiceEvents",
        includeGlobalServiceEvents
      )
    def getIsMultiRegionTrail: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isMultiRegionTrail", isMultiRegionTrail)
    def getIsOrganizationTrail: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isOrganizationTrail", isOrganizationTrail)
    def getKmsKeyId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getLogFileValidationEnabled: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("logFileValidationEnabled", logFileValidationEnabled)
    def getName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("name", name)
    def getS3BucketName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("s3BucketName", s3BucketName)
    def getS3KeyPrefix: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("s3KeyPrefix", s3KeyPrefix)
    def getSnsTopicArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("snsTopicArn", snsTopicArn)
    def getSnsTopicName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("snsTopicName", snsTopicName)
    def getTrailArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("trailArn", trailArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsCloudTrailTrailDetails
  ) extends zio.aws.securityhub.model.AwsCloudTrailTrailDetails.ReadOnly {
    override val cloudWatchLogsLogGroupArn: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cloudWatchLogsLogGroupArn())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val cloudWatchLogsRoleArn: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cloudWatchLogsRoleArn())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val hasCustomEventSelectors: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.hasCustomEventSelectors())
        .map(value => value: Boolean)
    override val homeRegion: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.homeRegion())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val includeGlobalServiceEvents: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.includeGlobalServiceEvents())
        .map(value => value: Boolean)
    override val isMultiRegionTrail: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.isMultiRegionTrail())
      .map(value => value: Boolean)
    override val isOrganizationTrail: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.isOrganizationTrail())
      .map(value => value: Boolean)
    override val kmsKeyId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val logFileValidationEnabled: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.logFileValidationEnabled())
        .map(value => value: Boolean)
    override val name: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val s3BucketName: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.s3BucketName())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val s3KeyPrefix: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.s3KeyPrefix())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val snsTopicArn: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.snsTopicArn())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val snsTopicName: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.snsTopicName())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val trailArn: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.trailArn())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsCloudTrailTrailDetails
  ): zio.aws.securityhub.model.AwsCloudTrailTrailDetails.ReadOnly = new Wrapper(
    impl
  )
}
